<?php

namespace App\Admin\Controllers;

use App\Models\Kefu;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;

class KefuController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new Kefu(), function (Grid $grid) {
            $grid->column('id');
            $grid->column('title', '平台客服名称');
            $grid->column('contact', '联系方式');
            $grid->column('is_type', '拨打/复制')->display(function ($val) {
                return $val == 1 ? '复制' : '拨打';
            });

            $grid->disableFilterButton();
            $grid->disableViewButton();
            $grid->disableEditButton();
            $grid->enableDialogCreate();
            $grid->showQuickEditButton();
            $grid->filter(function (Grid\Filter $filter) {
                $filter->equal('id');
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new Kefu(), function (Show $show) {
            $show->field('id');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new Kefu(), function (Form $form) {
            $form->display('id');
            $form->text('title', '平台客服名称');
            $form->text('contact', '联系方式');
            $form->select('is_type', '拨打/复制')->options([2 => '拨打', 1 => '复制']);
            // $form->display('created_at');
            // $form->display('updated_at');
        });
    }
}
