<?php

namespace App\Admin\Controllers;

use App\Admin\Metrics\Examples;
use App\Http\Controllers\Controller;
use Dcat\Admin\Http\Controllers\Dashboard;
use Dcat\Admin\Layout\Column;
use Dcat\Admin\Layout\Content;
use Dcat\Admin\Layout\Row;
use Dcat\Admin\Widgets\Card;
use Dcat\Admin\Widgets\Dropdown;
use Dcat\Admin\Widgets\Box;

class HomeController extends Controller
{
    public function index(Content $content)
    {
        //-----
        // 构建下拉菜单，当点击菜单时发起请求获取数据重新渲染图表
        $menu = [
            '7'  => '最近7天',
            '30' => '最近30天',
            '365' => '最近一年',
        ];
        $dropdown = Dropdown::make($menu)
            ->button(current($menu))
            ->click()
            ->map(function ($v, $k) {
                // 此处设置的 data-xxx 属性会作为post数据发送到后端api
                return "<a class='switch-bar' data-option='{$k}'>{$v}</a>";
            });

        // 传递自定义参数
        $id = 1;
        $username = 'jack';

        $bar = Examples\OrderAjaxBar::make($id, $username)
            ->fetching('$("#my-box").loading()') // 设置loading效果
            ->fetched('$("#my-box").loading(false)') // 移除loading效果
            ->click('.switch-bar'); // 设置图表点击菜单则重新发起请求，且被点击的目标元素上的 data-xxx 属性会被作为post数据发送到后端API

        $box = Box::make('销售额趋势', $bar)
            ->id('my-box') // 设置盒子的ID
            ->tool($dropdown); // 设置下拉菜单按钮
        //------
        return $content
            ->header('Dashboard')
            ->description('Description...')
            ->body(function (Row $row) use ($box) {
                $row->column(12, function (Column $column) use ($box) {
                    $column->row(function (Row $row) use ($box) {
                        $row->column(6, new Examples\OrderWaitCount());
                        $row->column(6, new Examples\OrderPickCount());
                        //$row->column(12, new Examples\StoreOrderChats());
                        //$row->column(12, Card::make('订单信息', Examples\MyBar::make()));
                        $row->column(12, Card::make('订单信息', $box));
                        $row->column(12, new Examples\Product());
                    });
                });


                // $row->column(12,'欢迎登录');
            });
    }
}
