<?php

namespace App\Admin\Controllers;

use App\Models\CheckNumber;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Illuminate\Support\Str;
use Dcat\Admin\Widgets\Modal;
use App\Admin\Forms\GenerateUserCode;

class CheckNumberController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new CheckNumber(), function (Grid $grid) {
            $grid->tools(function (Grid\Tools $tools) {
                $tools->append(Modal::make()
                    // 大号弹窗
                    ->lg()
                    // 弹窗标题
                    ->title('新增')
                    // 按钮
                    ->button('<button class="btn btn-primary"> 新增</button>')
                    // 弹窗内容
                    ->body(GenerateUserCode::make()->payload(['className' => CheckNumber::class])));
                //->body(ImportExcel::make()->payload(['className' => CheckNumber::class])));
            });
            $grid->model()->orderBy('id', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('code', '审核编号');
            $grid->column('status', '使用状态')->display(function ($val) {
                return $val == 0 ? '未使用' : '已使用';
            });;
            $grid->column('created_at');
            //$randomNumber = $this->generateRandomString(6);

            $grid->disableFilterButton();
            $grid->disableViewButton();
            $grid->disableEditButton();
            $grid->disableCreateButton();
            $grid->enableDialogCreate();
            $grid->filter(function (Grid\Filter $filter) {
                $filter->equal('id');
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new CheckNumber(), function (Show $show) {
            $show->field('id');
            $show->field('code');
            $show->field('status')->display(function ($val) {
                return $val == 0 ? '未使用' : '已使用';
            });
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new CheckNumber(), function (Form $form) {
            $form->display('id');
            $form->text('number', '生成数量');
            //$form->text('status');

            $form->display('created_at');
            $form->display('updated_at');
        });
    }
}
