<?php

namespace App\Admin\Controllers;

use App\Models\Category;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Layout\Content;
use Dcat\Admin\Layout\Row;
use Dcat\Admin\Tree;
use Dcat\Admin\Http\Controllers\AdminController;

class CategoryController extends AdminController
{

    public function index(Content $content)
    {
        return $content->header('分类')
            ->description('列表')
            ->body(function (Row $row) {
                $tree = new Tree(new Category());

                $tree->branch(function ($branch) {
                    return "{$branch['title']}";
                });
                $row->column(12, $tree);

                $tree->disableCreateButton();
            });
        return $content;
    }

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new Category(), function (Grid $grid) {
            $grid->column('id')->sortable();
            $grid->column('parent_id');
            $grid->column('title');
            $grid->column('icon');
            $grid->column('order');
            $grid->column('show');
            $grid->column('created_at');
            $grid->column('updated_at')->sortable();

            $grid->filter(function (Grid\Filter $filter) {
                $filter->equal('id');
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new Category(), function (Show $show) {
            $show->field('id');
            $show->field('parent_id');
            $show->field('title');
            $show->field('icon');
            $show->field('order');
            $show->field('show');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new Category(), function (Form $form) {
            $form->display('id');
            $form->select('parent_id')
                ->options(Category::selectOptions())
                ->saving(function ($v) {
                    return $v ?? 0;
                });
            $form->text('title');
            // $form->image('icon', '分类图标')
            //     ->accept('jpg,jpeg,png')
            //     ->maxSize(4096)
            //     ->url('upload/category')
            //     ->help('仅支持jpg、jpeg、png格式图片上传（750px * 420px）')
            //     ->autoUpload();
            $form->text('order')->help('越小越靠前');
            $form->switch('show', '状态')->default(1);

            // $form->display('created_at');
            // $form->display('updated_at');
        });
    }
}
