<?php

namespace App\Admin\Controllers;

use App\Models\Carousel;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;

class CarouselController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new Carousel(), function (Grid $grid) {
            $grid->addTableClass(['table-text-left']);
            $grid->model()->orderBy('created_at', 'DESC');
            $grid->column('id')->sortable()->width('10%');
            $grid->column('title')->width('30%');
            $grid->column('imgUrl')->image('', 100, 100)->width('20%');
            $grid->column('status')->switch();

            $grid->disableViewButton();
            $grid->disableEditButton();
            $grid->enableDialogCreate();
            $grid->showQuickEditButton();
            //$grid->disableFilterButton();
            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('title')->width(3);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new Carousel(), function (Show $show) {
            $show->field('id');
            $show->field('title');
            $show->field('imgUrl');
            $show->field('status');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new Carousel(), function (Form $form) {
            $form->text('title');
            $form->image('imgUrl')
                ->accept('jpg,jpeg,png')
                ->maxSize(4096)
                ->url('upload/carousel')
                ->help('仅支持jpg、jpeg、png格式图片上传(首页 600px*450px)')
                ->autoUpload();
            $form->switch('status')->default(1);
        });
    }
}
