<?php

namespace App\Admin\Actions;

use App\Command\Log;
use Dcat\Admin\Actions\Action;
use Dcat\Admin\Actions\Response;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;


/**
 * 导出商品
 *
 * @package App\Admin\Actions
 */
class GoodsExcel extends Action
{
    protected $request_param = [];

    protected $request_filename = '';

    protected $title = '';
    /**
     * 接收参数
     */
    public function __construct($param = [], $filename = '', $title = '')
    {
        $this->request_param = $param;
        $this->request_filename = $filename;
        parent::__construct($title);
        $this->title = $title;
    }


    //protected $title = '<button class="btn btn-primary"><i class="feather icon-download"></i> 下载模板</button>';
    /**
     * 按钮文本
     *
     * @return string|void
     */
    public function title()
    {
        return '<button class="btn btn-primary"><i class="feather icon-download"></i> ' . $this->title . '</button>';
    }

    /**
     * Handle the action request.
     *
     * @return Response
     */
    public function handle(Request $request)
    {
        $param = $request->get('param');
        $filename = $request->get('filename');
        //调用导出接口
        return $this->response()->download('/goods-export?filename=' . $filename . '&param=' . json_encode($param) . '&_export_=1');
    }

    public function parameters()
    {
        return [
            'mode' => '',
            'param' => $this->request_param,
            'filename' => $this->request_filename,
            'title' => $this->title,
        ];
    }
}
