<?php

namespace App\Admin\Actions;

use Dcat\Admin\Actions\Action;
use Dcat\Admin\Actions\Response;
use Illuminate\Support\Facades\Storage;


/**
 * 下载导入模板
 * Class DownloadTemplate
 *
 * @package App\Admin\Actions
 */
class DownloadTemplateExcel extends Action
{
    /**
     * @return string
     */
    protected $title = '<button class="btn btn-primary"><i class="feather icon-download"></i> 下载导入模板</button>';


    /**
     * Handle the action request.
     *
     * @return Response
     */
    public function handle()
    {
        $file_name = '';
        switch ($this->getKey()) {
            case 'good':
                $file_name = '商品资源库导入模版';
                break;
        }
        return $this->response()->download('/excelTemplate/' . $file_name . '.xlsx');
    }

    public function parameters()
    {
        return [
            'mode' => '',
        ];
    }
}
