<?php

namespace App\Store\Metrics\Examples;


use App\Models\StoreOrder;
use Dcat\Admin\Widgets\Metrics\Line;
use Illuminate\Http\Request;

class Revenue extends Line
{
    /**
     * 初始化卡片内容
     *
     * @return void
     */
    protected function init()
    {
        parent::init();

        $this->title('收益');
        $this->dropdown([
            '7' => '最近7天',
            '30' => '最近30天',
            '365' => '最近一年',
        ]);
    }

    /**
     * 处理请求
     *
     * @param Request $request
     *
     * @return mixed|void
     */
    public function handle(Request $request)
    {
        switch ($request->get('option')) {
            case '365':
                $data = StoreOrder::getYearSale();
                // 卡片内容
                $total = $data['total'] > 1000 ? round(2,($data['total']/1000)).' 千' : $data['total'];
                $this->withContent($total);
                // 图表数据
                $this->withChart($data['list']);
                break;
            case '30':
                $data = StoreOrder::getNumDaySale(30);
                // 卡片内容
                $total = $data['total'] > 1000 ? round(2,($data['total']/1000)).' 千' : $data['total'];
                $this->withContent($total);
                // 图表数据
                $this->withChart($data['list']);
                break;
            case '7':
            default:
                $data =  StoreOrder::getNumDaySale(7);
                // 卡片内容
                $total = $data['total'] > 1000 ? round(2,($data['total']/1000)).' 千' : $data['total'];
                $this->withContent($total);
                // 图表数据
                $this->withChart($data['list']);
        }
    }

    /**
     * 设置图表数据.
     *
     * @param array $data
     *
     * @return $this
     */
    public function withChart(array $data)
    {


        $series_data = [];
        foreach ($data as $v){
            $series_data[] = $v;
        }
        return $this->chart([
            'series' => [
                [
                    'name' =>'收益',
                    'data' => $series_data,
                ],
            ],

        ]);
    }

    /**
     * 设置卡片内容.
     *
     * @param string $content
     *
     * @return $this
     */
    public function withContent($content)
    {
        return $this->content(
            <<<HTML
<div class="d-flex justify-content-between align-items-center mt-1" style="margin-bottom: 2px">
    <h2 class="ml-1 font-lg-1">{$content}</h2>
    <span class="mb-0 mr-1 text-80">{$this->title}</span>
</div>
HTML
        );
    }
}
