<?php

namespace App\Store\Metrics\Examples;

use App\Models\OrderInfo as OrderInfoModel;
use App\Models\MerchantGoodSku;
use App\Models\OrderGoods;
use Dcat\Admin\Widgets\Metrics\Card;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Dcat\Admin\Admin;

class LastStockTotal extends Card
{
    /**
     * 卡片底部内容.
     *
     * @var string|Renderable|\Closure
     */
    protected $footer;

    /**
     * 初始化卡片.
     */
    protected function init()
    {
        parent::init();

        $this->title('库存剩余总数');
    }

    /**
     * 处理请求.
     *
     * @param Request $request
     *
     * @return void
     */
    public function handle(Request $request)
    {
        switch ($request->get('option')) {
            case '365':
            case '30':
            case '7':
            default:
                $mer_id = Admin::user()->merchant_id;
                $firstDayOfMonth = date('Y-m-01 00:00:00'); // 00:00:00
                $lastDayOfMonth = date("Y-m-t 23:59:59", time());
                $currentStock = MerchantGoodSku::where("merchant_id", $mer_id)->sum('stock');
                //本月订单商品销量
                $goods_number = OrderGoods::where(['merchant_id' => $mer_id, 'is_pay' => 1])
                    ->whereBetween('created_at', [$firstDayOfMonth, $lastDayOfMonth])->sum('goods_number');
                $total = $goods_number + $currentStock;
                // 卡片内容
                $this->withContent($total);
                // 图表数据
                //$this->withChart($data['list']);
        }
    }



    /**
     * 设置卡片内容.
     *
     * @param string $content
     *
     * @return $this
     */
    public function withContent($content)
    {
        return $this->content(
            <<<HTML
<div class="d-flex justify-content-between align-items-center mt-1" style="margin-bottom: 2px">
    <h2 class="ml-1 font-lg-1">{$content}</h2>
</div>
HTML
        );
    }
}
