<?php

namespace App\Models;

use App\Command\Log;
use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class OrderInfo extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'li_order_info';

    public const STATUS_OPTIONS = [
        0 => '待付款',
        1 => '待到货',
        2 => '待领取',
        3 => '待评价',
        4 => '已完成',
        7 => '已取消',
        8 => '已退款',
        //9 => '已收货',//分账资金冻结7天，用户确认收货后汇付会立即解冻资金，t+1后资金分账，所以需要平台自己控制6天冻结，不分账，这期间可以退款
    ];


    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function merchant()
    {
        return $this->belongsTo(Merchant::class, 'merchant_id');
    }

    /**
     * 获取日期订单量
     * started 开始时间
     * ended 截至时间
     * status 订单状态
     * merchant_id 商户ID
     */
    public static function getNumData($started = '', $ended = '', $status = [], $merchant_id = 0)
    {
        DB::enableQueryLog();
        $where = ['pay_status' => 1];
        $sqlObj = new self();
        if ($merchant_id) {
            $where['merchant_id'] = $merchant_id;
        }
        if ($status) {
            $sqlObj = $sqlObj->whereIn('order_status', $status);
        }
        if ($started && $ended) {
            $startTime = $started . ' 00:00:00';
            $endTime = $ended . ' 23:59:59';
            $sqlObj = $sqlObj->whereBetween('created_at', [$startTime, $endTime]);
        }
        $count = $sqlObj->where($where)->count();
        //$queries = DB::getQueryLog();
        //Log::add("待收货统计日志", $queries);
        return $count;
    }
    //指定天数
    public static function getNumDayData($dayNum, $status = [])
    {
        $days = [date('Y-m-d')];
        for ($i = 1; $i < $dayNum; $i++) {
            $days[] = date("Y-m-d", strtotime("-$i day"));
        }
        $days = array_reverse($days);
        $data = [
            'total' => 0,
            'list' => []
        ];
        //DB::enableQueryLog();
        $sqlObj = new self();
        foreach ($days as $day) {
            $startTime = $day . ' 00:00:00';
            $endTime = $day . ' 23:59:59';
            $count = $sqlObj->whereIn('order_status', $status)->whereBetween('created_at', [$startTime, $endTime])->count();
            //$queries = DB::getQueryLog();
            $data['list'][$day] = $count;
            $data['total'] += $count;
        }

        return $data;
    }

    //统计获取默天的销售额
    public static function getDayAmount($dayDate)
    {
        $startTime = $dayDate . ' 00:00:00';
        $endTime = $dayDate . ' 23:59:59';
        $sqlObj = new self();
        $amount = $sqlObj->whereBetween('created_at', [$startTime, $endTime])
            ->where('pay_status', 1)
            ->whereNull('deleted_at')->sum('order_amount');
        return $amount;
    }


    //统计获取月销售额 2023-09
    public static function getMonthAmount($monthDate)
    {
        $mdate = $monthDate . "-01";

        $firstDayOfMonth = date('Y-m-01', strtotime(date($mdate)));
        $lastDayOfMonth  = date('Y-m-t', strtotime(date($mdate)));

        $startTime = $firstDayOfMonth . ' 00:00:00';
        $endTime = $lastDayOfMonth . ' 23:59:59';
        $sqlObj = new self();
        $amount = $sqlObj->whereBetween('created_at', [$startTime, $endTime])
            ->where('pay_status', 1)
            ->whereNull('deleted_at')->sum('order_amount');
        return $amount;
    }

    //获取最近一年的订单量
    public static function getYearData()
    {
        $y = date('Y');
        $m = date('m');

        for ($i = 1; $i <= $m; $i++) {
            $days[] = $y . '-' . $i;
        }
        $data = [
            'total' => 0,
            'list' => []
        ];
        $where = [];
        foreach ($days as $day) {
            $startTime = $day . '-01 00:00:00';
            $m_max_day = date('t', strtotime($startTime));
            $endTime = $day . '-' . $m_max_day . ' 23:59:59';
            $count = self::whereBetween('created_at', [$startTime, $endTime])->where($where)->count();
            $data['list'][$day] = $count;
            $data['total'] += $count;
        }
        return $data;
    }

    // public static function getOrderTitle($order_sn){
    //     $order = self::find($order_sn);
    //     $project = '';
    //     $service_name =Service::find($order->service_id)->name ?? '';
    //     $business_name = Business::find($order->business_id)->name ?? '';
    //     switch ($order->business_id){
    //         case 1:
    //         case 2:
    //         case 4:
    //             $project = $service_name;
    //             break;
    //         case 3:
    //             $project = $business_name.'('.$service_name.')';
    //             break;
    //         case 5:
    //         case 6:
    //             $project = $business_name;
    //             break;
    //         default:
    //             $goods_id = StoreOrder::where(['order_id'=>$order_id])->first()->goods_id;
    //             $goods_name = StoreGood::find($goods_id)->title ??'';
    //             $project = '商城订单-'.$goods_name;
    //     }
    //     return $project;
    // }




















}
