<?php

namespace App\Jobs;

use App\Imports\ImportExcel;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;


class ansyImportExcel implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private string $className;
    private string $file_path;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($className, $file_path)
    {
        $this->className = $className;
        $this->file_path = $file_path;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //$toolOrder = new ImportExcel($this->className, $this->file_path);
        Excel::import($toolOrder, $this->file_path);
    }
}
