<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Models\Merchant;
use App\Models\User as UserModel;
use App\Models\OrderDivideRecord;
use App\Models\OrderGoods;
use App\Models\OrderInfo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class MerchantController extends BaseController
{
    //绑定直购码用户列表
    public function getUserList(Request $request)
    {
        $mer_id = $request->user()->merchant_id;
        $merObj = Merchant::where('id', $mer_id)->first();
        $buycode = $merObj->buycode ?? '';
        if (!$buycode) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        $page = $request->page ?? 1;
        $limit = $request->limit ?? 10;

        $sql = UserModel::where(['buycode' => $buycode, 'status' => 1, 'deleted_at' => null]);

        $total = $sql->count();
        $data = [
            'divideAmount' => 0,
            'total' => $total,
            'total_page' => ceil($total / $limit),
            'list' => []
        ];
        //商户佣金总额
        $divideAmount = OrderDivideRecord::where(['sh_type' => 3, 'um_id' => $mer_id])->sum('divide_price');
        $data['divideAmount'] = (float)$divideAmount;

        $listData = $sql->offset(($page - 1) * $limit)->limit($limit)->orderBy('created_at', 'DESC')->get();
        if ($listData->toArray()) {
            foreach ($listData as $item) {
                //获取会员给商户产生的佣金
                $uid = $item->id;
                $divide_price = OrderDivideRecord::where(['sh_type' => 3, 'um_id' => $mer_id, 'user_id' => $uid])->sum('divide_price');
                $data['list'][] = [
                    'uid' => $uid,
                    'name' => $item->name,
                    'divide_price' => (float)$divide_price,
                    'avatar' => $item->avatar ? env('IMAGE_URL') . $item->avatar : env('NO_AVATAR_IMAGE_URL'),
                    'created_at' => date('Y-m-d H:i:s', strtotime($item->created_at)),
                ];
            }
        }

        return  $this->JsonResponse($data);
    }

    //我的用户-订单列表(展示近10天)
    public function getOrderList(Request $request)
    {
        $mer_id = $request->user()->merchant_id;
        $user_id = $request->user_id ?? 0;
        if (!$user_id) {
            return $this->JsonResponse('', '参数错误', 201);
        }

        $daysAgo = date('Y-m-d H:i:s', strtotime("-10 days"));
        $list = DB::table("order_divide_record as odr")
            ->select(DB::raw('odr.order_id, o.order_status,o.created_at'))
            ->leftJoin('li_order_info as o', 'odr.order_id', '=', 'o.id')
            ->whereDate('odr.created_at', '>', $daysAgo)
            ->where(['odr.sh_type' => 3, 'odr.um_id' => $mer_id, 'odr.user_id' => $user_id])
            ->orderBy('odr.created_at', 'DESC')  // 添加时间倒序排序
            ->limit(100)
            ->get()
            ->toArray();

        foreach ($list as $key => $item) {
            $order_goods = [];
            if ($item->order_id) {  // 确保订单ID存在
                $ogRows = DB::table('li_order_goods')
                    ->where('order_id', $item->order_id)
                    ->select(DB::raw('goods_name,goods_number,goods_price,goods_img,goods_attr'))
                    ->get()
                    ->toArray();

                foreach ($ogRows as $valObj) {
                    $order_goods[] = [
                        'goods_name' => $valObj->goods_name,
                        'goods_number' => $valObj->goods_number,
                        'goods_attr' => $valObj->goods_attr,
                        'goods_price' => $valObj->goods_price,
                        'goods_img' => $valObj->goods_img ? togetherFilePath($valObj->goods_img) : '',
                    ];
                }
            }

            $list[$key]->status_txt = $item->order_status ? (OrderInfo::STATUS_OPTIONS[$item->order_status] ?? '未知状态') : '订单不存在';
            $list[$key]->og = $order_goods;
        }

        return  $this->JsonResponse($list);
    }
}
