<?php

namespace App\Admin\Metrics\Examples;

use App\Models\OrderInfo;
use Illuminate\Http\Request;

class OrderAjaxBar extends OrderBar
{
    protected $id;
    protected $username;

    // 这里的参数一定要设置默认值
    public function __construct($id = null, $username = null)
    {
        parent::__construct();

        $this->id = $id;
        $this->username = $username;
    }

    /**
     * 处理请求
     * 如果你的图表类中包含此方法，则可以通过此方法处理前端通过ajax提交的获取图表数据的请求
     *
     * @param Request $request
     * @return mixed|void
     */
    public function handle(Request $request)
    {
        // 获取 parameters 方法设置的自定义参数
        $id = $request->get('id');
        $username = $request->get('username');

        switch ((int) $request->get('option')) {
            case 365:
                $monthArr = $amounts = [];
                for ($i = 11; $i >= 0; $i--) {
                    $month = date('Y-m', strtotime('-' . $i . ' month'));
                    array_push($monthArr, $month);
                    $orderAmount = OrderInfo::getMonthAmount($month);
                    array_push($amounts, $orderAmount);
                }
                // 你的数据查询逻辑
                $data = [
                    [
                        'data' => $amounts //[44, 55, 41, 64, 22, 43, 21]
                    ]
                ];
                $categories = $monthArr; //[2001, 2002, 2003, 2004, 2005, 2006, 2007];

                break;
            case 30:
                $dayArr = $amounts = [];
                for ($i = 30; $i >= 0; $i--) {
                    $day = date("Y-m-d", strtotime("-" . $i . " day"));
                    array_push($dayArr, $day);
                    $orderAmount = OrderInfo::getDayAmount($day);
                    array_push($amounts, $orderAmount);
                }

                // 你的数据查询逻辑
                $data = [
                    [
                        'data' => $amounts //[44, 55, 41, 64, 22, 43, 21]
                    ]
                ];
                $categories = $dayArr;

                break;
            case 7:
            default:
                $dayArr = $amounts = [];
                for ($i = 7; $i >= 0; $i--) {
                    $day = date("Y-m-d", strtotime("-" . $i . " day"));
                    array_push($dayArr, $day);
                    $orderAmount = OrderInfo::getDayAmount($day);
                    array_push($amounts, $orderAmount);
                }

                // 你的数据查询逻辑
                $data = [
                    [
                        'data' => $amounts
                    ]
                ];
                $categories = $dayArr; //[2001, 2002, 2003, 2004, 2005, 2006, 2007];
                break;
        }

        $this->withData($data);
        $this->withCategories($categories);
    }

    /**
     * 这里返回需要异步传递到 handler 方法的参数 
     * 
     * @return array
     */
    public function parameters(): array
    {
        return [
            'id'        => $this->id,
            'username' => $this->username,
        ];
    }

    /**
     * 这里覆写父类的方法，不再查询数据
     */
    protected function buildData() {}
}
