<?php

namespace App\Admin\Forms;


use App\Models\PersonalAccessToken;
use App\Models\User;
use App\Models\UserPermission;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Dcat\Admin\Widgets\Form;


class updatePassword extends Form  implements LazyRenderable
{
    use LazyWidget;
    /**
     * Handle the form request.
     *
     * @param array $input
     *
     * @return mixed
     */
    public function handle(array $input)
    {

        $user = User::find($this->payload['id']);
        $user->password = bcrypt($input['password']);
        if(!$user->save()){
            return $this
                ->response()
                ->error('修改用户密码失败')
                ->refresh();
        }
        PersonalAccessToken::where(['tokenable_id'=>$user->id])->delete();
        return $this
            ->response()
            ->success('修改用户密码成功.')
            ->refresh();
    }

    /**
     * Build a form here.
     */
    public function form()
    {

        $this->display('name','姓名');
        $this->display('phone','手机');
        $this->text('password','密码')->required();
    }

    /**
     * The data of the form.
     *
     * @return array
     */
    public function default()
    {
        $user = User::find($this->payload['id']);
        return [
            'name'  => $user->name,
            'phone' => $user->phone,
        ];
    }
}
