<?php

namespace App\Admin\Controllers;

use App\Models\SystemSetting;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;

class SystemSettingController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new SystemSetting(), function (Grid $grid) {
            $grid->column('id')->sortable();
            $grid->column('title');
            $grid->column('cover')->image('', 100, 100);
            $grid->column('is_show', '状态')->switch();
            $grid->column('created_at');
            //$grid->column('updated_at')->sortable();

            $grid->disableViewButton();

            $grid->filter(function (Grid\Filter $filter) {
                $filter->like('title');
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new SystemSetting(), function (Show $show) {
            $show->field('id');
            $show->field('title');
            $show->field('cover');
            $show->field('content');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new SystemSetting(), function (Form $form) {
            //$form->display('id');
            $form->image('bj_invite', '邀请页背景图')
                ->accept('jpg,jpeg,png')
                ->maxSize(4096)
                ->url('upload/carousel')
                ->help('仅支持jpg、jpeg、png格式图片上传（690px * 1200px）')
                ->autoUpload();
            $form->editor('cp_brief', '公司介绍');
            $form->editor('cashout_brief', '提现须知');
            //$form->display('created_at');
            //$form->display('updated_at');
            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();
            $form->disableListButton();
            $form->disableResetButton();

            $form->saved(function (Form $form) {
                return $form->response()->success('保存成功')->redirect('/setting/1/edit');
            });
        });
    }
}
