<?php

namespace App\Admin\Controllers;

use App\Models\OrderDivideRecordDongJie;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Form;
use Dcat\Admin\Http\Controllers\AdminController;

class OrderDivideRecordDongJieController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        // 使用视图查询数据
        return Grid::make(new OrderDivideRecordDongJie(), function (Grid $grid) {
            
            // 直接使用视图查询，利用Eloquent的分页功能
            $grid->model()
                ->select('*')
                ->from('order_divide_view')
                ->orderBy('id', 'desc');
            
            // 隐藏列
            $grid->column('id', trans('order-divide-record.fields.id'))->hide();
            // $grid->column('goods_id', trans('order-divide-record.fields.goods_id'))->hide();
            // $grid->column('order_id', trans('order-divide-record.fields.order_id'))->hide();
            // $grid->column('merchant_id', trans('order-divide-record.fields.merchant_id'))->hide();

            // 显示列
            $grid->column('order_sn', trans('order-divide-record.fields.order_sn'));
            $grid->column('mobile', trans('order-divide-record.fields.mobile'));
            
            $grid->column('merchant_commission', trans('order-divide-record.fields.merchant_commission'));
            $grid->column('employee_commission', trans('order-divide-record.fields.employee_commission'));

            $grid->column('name2', trans('order-divide-record.fields.name2'));
            $grid->column('name', trans('order-divide-record.fields.name'));

            $grid->column('goods_price', trans('order-divide-record.fields.goods_price'));
            //$grid->column('merchant_amount', trans('order-divide-record.fields.merchant_amount'));
            $grid->column('merchant_employee_amount', trans('order-divide-record.fields.merchant_employee_amount'));
            $grid->column('divide_price', trans('order-divide-record.fields.divide_price'));
            $grid->column('platform_amount', trans('order-divide-record.fields.platform_amount'));
            
            $grid->column('created_at', trans('order-divide-record.fields.created_at'));

            // 禁用操作按钮
            $grid->disableCreateButton();
            $grid->disableActions();
            $grid->disableRowSelector();
            
            // 启用筛选功能
            $grid->filter(function (Grid\Filter $filter) {
                // 默认展开筛选面板
                $filter->panel();
                
                // 订单号筛选
                $filter->like('order_sn', trans('order-divide-record.fields.order_sn'), '订单sn');
                
                // 手机号筛选
                $filter->like('mobile', trans('order-divide-record.fields.mobile'));
                
                // 商户名称筛选
                $filter->like('name2', trans('order-divide-record.fields.name2'));
                
                // 员工名称筛选
                $filter->like('name', trans('order-divide-record.fields.name'));
                
                // 创建时间范围筛选
                $filter->between('created_at', trans('order-divide-record.fields.created_at'))->datetime();
            });
            
            // 设置分页选择器
            $grid->perPages([10, 20, 50, 100]);
            
            $grid->export()->csv();
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new OrderDivideRecordDongJie(), function (Show $show) {
            $show->field('id');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new OrderDivideRecordDongJie(), function (Form $form) {
            $form->display('id');
        });
    }
}