<?php

namespace App\Admin\Controllers;

use App\Command\Log;
use App\Models\HfSettleAccount;
use App\Models\HfProvAreaCode;
use App\Models\Adapay;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Widgets\Card;
use App\Models\Merchant;
use Illuminate\Support\Facades\DB;

class HfSettleAccountController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new HfSettleAccount(), function (Grid $grid) {
            $grid->column('id')->sortable();
            $grid->model()->orderBy('created_at', 'DESC');
            
            $grid->column('member_type', '用户类型')->display(function ($val) {
                return $val == 1 ? '商户' : '普通用户';
            });
            
            $grid->column('mid', '用户/商户ID');
            $grid->column('card_name', '户名');
            $grid->column('cert_id', '证件号')->display(function ($val) {
                if (strlen($val) <= 4) {
                    return $val; // 如果长度小于等于4位，直接显示
                }
                return substr($val, 0, 2) . '****' . substr($val, -2);
            });
            $grid->column('tel_no', '手机号');
            //$grid->column('bank_name', '开户银行');
            $grid->column('bank_acct_type', '账号类型')->display(function ($val) {
                return $val == 1 ? '对公' : '对私';
            });
            $grid->column('account_id', '结算账户号');
            
            $grid->disableViewButton();
            $grid->disableDeleteButton();
            $grid->disableRowSelector();
            $grid->disableViewButton();
            $grid->disableEditButton();
            $grid->disableCreateButton();
            $grid->disableActions();
            $grid->simplePaginate();

            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel();
                $filter->like('card_name', '户名')->width(3);
                $filter->like('tel_no', '手机号')->width(3);
                $filter->equal('member_type', '用户类型')->select([
                    0 => '普通用户',
                    1 => '商户'
                ])->width(3);
            });
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new HfSettleAccount(), function (Form $form) {
            $form->display('id');
            
            $form->radio('member_type', '用户类型')
                ->options([0 => '普通用户', 1 => '商户'])
                ->default(0)
                ->required();
                
            // $form->text('mid', '用户/商户ID')->required();
            // $form->text('card_id', '银行卡号')->required();
            // $form->text('card_name', '户名')->required();
            // $form->text('cert_id', '证件号')->required();
            // $form->select('cert_type', '证件类型')
            //     ->options(['00' => '身份证', '01' => '护照', '02' => '军官证'])
            //     ->default('00')
            //     ->required();
                
            // $form->text('tel_no', '手机号')->required();
            // $form->text('bank_code', '银行编号')->required();
            // $form->text('bank_name', '开户银行')->required();
            // $form->radio('bank_acct_type', '账号类型')
            //     ->options([1 => '对公', 2 => '对私'])
            //     ->default(1)
            //     ->required();
                
            // $form->text('account_id', '结算账户号')->required();
            // $form->select('prov_code', '省份')
            //     ->options(HfProvAreaCode::where('parent_id', 0)->pluck('title', 'area_code'))
            //     ->rules('required')
            //     ->load('area_code', '/hf-area-code');
                
            // $form->select('area_code', '城市')->required();
            
            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();
        });
    }
}
