<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\Article;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use App\Models\Category;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Widgets\Modal;
use Dcat\Admin\Widgets\Card;

class ArticleController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(Article::with(['cat']), function (Grid $grid) {
            $grid->model()->orderBy('created_at', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('title')->limit(20);
            $grid->column('brief', '副标题')->limit(20);
            $grid->column('cat.title', '分类名称');
            $grid->column('content')->if(function ($column) {
                return $column->getValue();
            })->display('点击查看')->modal(function ($modal) {
                //设置弹窗标题
                $modal->title('文章内容');

                $card = new Card(null, $this->content);

                return "<div style='padding:10px 10px 0;width:100%;'>$card</div>";
            })->else(function ($column) {
                return '';
            });
            // $grid->column('created_at');
            // $grid->column('updated_at')->sortable();
            $grid->disableViewButton();
            $grid->disableRowSelector();
            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('title')->width(3);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new Article(), function (Show $show) {
            $show->field('id');
            $show->field('title');
            $show->field('cat_id');
            $show->field('content');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new Article(), function (Form $form) {
            $form->display('id');
            $form->text('title');
            $form->select('cat_id', '商品分类')
                ->options(Category::selectOptions())
                ->saving(function ($v) {
                    return $v ?? 0;
                });
            $form->image('cover', '封面')
                ->url('upload/user')
                ->autoUpload();
            $form->editor('content');

            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();
        });
    }
}
