<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use App\Models\Store;

class Merchant extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;
    protected $table = 'merchant';

    public function store_desc()
    {
        return $this->hasMany(Store::class, 'merchant_id');
    }
}
