<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Models\Adapay;
use App\Models\OrderDivideRecord;
use App\Models\Good as GoodModel;
use App\Models\OrderInfo;
use App\Models\OrderGoods;
use App\Models\OrderInfo as OrderInfoModel;
use App\Models\MerchantGoodSku;
use App\Models\PaymentRecord;
use App\Models\HfPayconfirm;
use Dcat\Admin\Grid\Displayers\Orderable;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use League\CommonMark\Node\Query\OrExpr;

class HfOrderController extends BaseController
{
    //退款回调
    public function refundNotify()
    {
        Log::add('--撤销回调结果--', $_POST);
        $fields = $_POST ?? [];

        $res = (new Adapay())->refundNotify($fields);
        return $res;
    }

    //手动创建支付确认对象
    public function paymentConfirm(Request $request)
    {
        $order_id = $request->order_id ?? 0;

        $orderObj = OrderInfo::where(['id' => $order_id])->first();
        if (!$orderObj) {
            return $this->JsonResponse('', '订单不存在', 201);
        }

        //解冻通知
        $order_no = $orderObj->order_sn;
        $freeze_stat = $message['freeze_stat'] ?? '';
        if ($orderObj->freeze_stat == 'FREEZE') {
            //交易记录
            $prObj = PaymentRecord::where('order_sn', $order_no)->first();
            # 支付确认参数设置
            $payment_params = array(
                "payment_id" => $prObj->payment_id,
                "order_no" => 'payconfirm_' . date("YmdHis") . rand(100000, 999999),
                "confirm_amt" => 0,
                "description" => "",
                "div_members" => "" //分账参数列表 默认是数组List
            );

            DB::beginTransaction();
            try {
                //分账列表
                $divResult = OrderDivideRecord::divide($orderObj->id, $payment_params['order_no']); //返回分账参数列表
                $payment_params['div_members'] = $divResult['div_members'];
                $payment_params['confirm_amt'] = $divResult['confirm_amt'];
                Log::add('发起支付确认', $payment_params);
                $orderObj->freeze_stat = 'UNFREEZE';
                if ($orderObj->save()) {
                    $result = (new Adapay())->createPaymentConfirm($payment_params);
                    if ($result['status'] == 'succeeded') {
                        (new HfPayconfirm())->add($payment_params, $result['fee_amt']);
                    }
                }
                DB::commit();
            } catch (\Exception $e) {
                Log::add('解冻，支付确认对象失败', $e->getMessage());
                DB::rollBack();
                return $this->JsonResponse('', $e->getMessage(), 201);
            }
            return $this->JsonResponse($result);
        }
    }

    //定时任务--查询支付对象列表
    public function autoQueryList()
    {
        $payment_params = array(
            "app_id" => env('HUIFU_APPID'),
            //"payment_id" => "10000000000000001",
            //"order_no" => "20190919071231283468359213",
            "page_index" => "",
            "page_size" => "",
            "created_gte" => "",
            "created_lte" => ""
        );
        $chunkSize = 10; // 每次处理的订单数量
        $orders = OrderInfoModel::where(["freeze_stat" => 'FREEZE'])->orderBy('id', 'desc')->take($chunkSize);
        while ($orders->count() > 0) {
            $orders->chunk($chunkSize, function ($batch) use ($payment_params) {
                foreach ($batch as $order) {
                    $nowtime = time();
                    $pyObj = PaymentRecord::where('order_sn', $order->order_sn)->first();
                    $payment_params['payment_id'] = $pyObj->payment_id;
                    $payment_params['order_no'] = $pyObj->order_sn;
                    $result = (new Adapay())->queryList($payment_params);
                    // if ($order->created_at) {
                    //     $created_at = strtotime($order->created_at);
                    //     $diff_time = $nowtime - $created_at;
                    //     if ($diff_time > 900) {
                    //         $order->save();
                    //     }
                    // }
                }
            });

            // 移动游标到下一批
            $orders->skip($chunkSize);
            $orders = $orders->getQuery();
            sleep(2);
        }

        return '--ok--';
    }
}
