<?php

namespace App\Admin\Renderable;


use App\Models\OrderGoods;
use App\Models\Good as GoodModel;
use App\Models\Category;
use Dcat\Admin\Grid;
use Dcat\Admin\Grid\LazyRenderable;

class OrderGoodsList extends LazyRenderable
{
    public function grid(): Grid
    {
        // 获取外部传递的参数
        $order_id = $this->payload['order_id'] ?? [];

        return Grid::make(new OrderGoods(), function (Grid $grid) use ($order_id) {

            $grid->addTableClass(['table-text-center']);
            $grid->model()->where('order_id', $order_id);
            //$grid->column('goods_img', '图片')->image(env("IMAGE_URL"), 50);
            $grid->column('goods_name', '标题')->display(function ($val) {
                return $val . "(" . $this->id . ")";
            })->width(300);
            $grid->column('goods_attr', '规格')->limit(10);
            $grid->column('goods_number', '数量')->limit(10);
            $grid->column('goods_price', '价格')->limit(10);
            $grid->column('total', '合计')->display(function ($val) {
                $num = $this->goods_number;
                $price = $this->goods_price;
                return sprintf("%.2f", $price * $num);
            });

            $grid->disableCreateButton();
            $grid->disableRefreshButton();
            $grid->disablePagination();
            $grid->disableViewButton();
            $grid->disableEditButton();
            $grid->disableRowSelector();
            $grid->disableDeleteButton();
            $grid->disableActions();
            //屏蔽删除
            //$grid->actions(new DeleteService());
        });
    }
}
