<?php

namespace App\Admin\Metrics\Examples;

use Dcat\Admin\Widgets\Metrics\Line;
use App\Models\OrderInfo;
use Illuminate\Http\Request;
use Dcat\Admin\widgets\Metrics\RadialBar;
use App\Traits\DatepickerTrait;



class OrderWaitCount extends Line
{
    use DatepickerTrait;

    protected $view = "widgets.metrics.card";

    /**
     * 初始化卡片内容
     *
     * @return void
     */
    protected function init()
    {
        parent::init();

        $this->title('待取货总数');
        $this->dropdown([
            '1' => '今天',
            '7' => '最近7天',
            '30' => '最近30天',
            '365' => '最近一年',
        ]);
        #日期选择开始
        // $id = $this->id();
        // $this->datepicker($id)
        //     ->click("#{$id} .datepicker .btn-primary")
        //     ->addVariables([
        //         'datepicker' => [
        //             'start' => '', //date('Y-m-d', strtotime('-7 days')),
        //             'end' => '', //date('Y-m-d', time()),
        //         ]
        //     ]);
    }

    /**
     * 处理请求
     *
     * @param Request $request
     *
     * @return mixed|void
     */
    public function handle(Request $request)
    {
        //dd($request->input());
        // $started = $request->get('started') ?? '';
        // $ended = $request->get('ended') ?? '';

        switch ($request->get('option')) {
            case '365':
                $data = OrderInfo::getNumDayData(365, [2]);
                // 卡片内容
                $this->withContent($data['total']);
                // 图表数据
                $this->withChart($data['list']);
                break;
            case '30':
                $data = OrderInfo::getNumDayData(30, [2]);
                // 卡片内容
                $this->withContent($data['total']);
                // 图表数据
                $this->withChart($data['list']);
                break;
            case '7':
                $data = OrderInfo::getNumDayData(7, [2]);
                // 卡片内容
                $this->withContent($data['total']);
                // 图表数据
                $this->withChart($data['list']);
                break;
            default:
                $data = OrderInfo::getNumDayData(1, [2]);
                // 卡片内容
                $this->withContent($data['total']);
                // 图表数据
                $this->withChart($data['list']);
        }
    }


    /**
     * 设置图表数据.
     *
     * @param array $data
     *
     * @return $this
     */
    public function withChart(array $data)
    {


        $series_data = [];
        foreach ($data as $v) {
            $series_data[] = $v;
        }
        return $this->chart([
            'series' => [
                [
                    'name' => $this->title,
                    'data' => $series_data,
                ],
            ],
            'stroke' => [
                'curve' => 'smooth'
            ],
        ]);
    }
    // public function withChart(array $data)
    // {
    //     return $this->chart([
    //         'series' => [
    //             [
    //                 'name' => $this->title,
    //                 'data' => $data,
    //             ],
    //         ],
    //     ]);
    // }

    /**
     * 设置卡片内容.
     *
     * @param string $content
     *
     * @return $this
     */
    public function withContent($content)
    {
        return $this->content(
            <<<HTML
<div class="d-flex justify-content-between align-items-center mt-1" style="margin-bottom: 2px">
    <h2 class="ml-1 font-lg-1">{$content}</h2>
</div>
HTML
        );
    }
}
