<?php

namespace App\Store\Metrics\Examples;

use App\Models\OrderInfo as OrderInfoModel;
use Dcat\Admin\Widgets\Metrics\Card;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Dcat\Admin\Admin;

class LastPickupTotal extends Card
{
    /**
     * 卡片底部内容.
     *
     * @var string|Renderable|\Closure
     */
    protected $footer;

    /**
     * 初始化卡片.
     */
    protected function init()
    {
        parent::init();

        $this->title('已取货状态');
    }

    /**
     * 处理请求.
     *
     * @param Request $request
     *
     * @return void
     */
    public function handle(Request $request)
    {
        switch ($request->get('option')) {
            case '365':
            case '1':
            case '7':
            case '60':
            default:
                $started = date('Y-m-01', strtotime('last month'));
                $ended = date('Y-m-t', strtotime('last month'));
                $order_status = [3, 4];
                $count = OrderInfoModel::getNumData($started, $ended, $order_status, Admin::user()->merchant_id);
                // 卡片内容

                $this->withContent($count);
                // 图表数据
                //$this->withChart($data['list']);
        }
    }



    /**
     * 设置卡片底部内容.
     *
     * @param string|Renderable|\Closure $footer
     *
     * @return $this
     */
    public function footer($footer)
    {
        $this->footer = $footer;

        return $this;
    }

    /**
     * 设置卡片内容.
     *
     * @param string $content
     *
     * @return $this
     */
    public function withContent($content)
    {
        return $this->content(
            <<<HTML
<div class="d-flex justify-content-between align-items-center mt-1" style="margin-bottom: 2px">
    <h2 class="ml-1 font-lg-1">{$content}</h2>
</div>
HTML
        );
    }
}
