<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StoreEmployeeUserRec extends Model
{
    /**
     * 禁用时间戳
     * 功能：禁用模型的自动时间戳更新
     * 返回值：bool 是否禁用时间戳
     * 注意事项：此表不包含updated_at字段
     */
    public $timestamps = false;

    /**
     * 可批量赋值的属性
     * 功能：定义允许通过create方法批量赋值的字段
     * 返回值：array 可批量赋值的字段数组
     * 注意事项：必须包含所有需要通过create方法赋值的字段
     */
    protected $fillable = [
        'user_id',
        'employee_id',
        'created_at'
    ];
    protected $table = 'store_employee_user_rec';
    
    
    //分享人信息
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    
    //分享人信息
    public function employee()
    {
        return $this->belongsTo(StoreAdminUsers::class, 'employee_id');
    }
}
