<?php

namespace App\Models;

use App\Command\Log;
use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class OrderDivideRecord extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;
    protected $table = 'order_divide_record';

    //佣金类别-//就是字段sh_type
    public const COMMISSION_TYPE = [
        0 => '平台',
        3 => '商户',
        5 => '员工',
        1 => '直推', //需求调整，不再分账，改成积分，支付时抵扣
        2 => '间推', //需求调整，不再分账，改成积分，支付时抵扣
        4 => '手动调账分账',
    ];




    /**
     * 收益分配
     * @param int $order_id 订单ID
     * @param string $payconfirm_no 发起确认支付，订单流水号
     * @return array 包含分账成员和确认金额的数组
     */
    public static function divide($order_id, $payconfirm_no = '')
    {
        $div_members = []; //汇付 分账对象
        $orderObj = OrderInfo::find($order_id);
        $merchant_id = $orderObj->merchant_id; //绑定的商户
        $buyer_id = $orderObj->user_id; //下单用户ID
        $total_amount = 0; //订单商品总价
        $merchant_proportion = ''; //佣金比例
        $sp_ogid = ''; //参与分佣商品ID
        $employeeObj = []; //员工对象;
        $commissionPreData = [
            'merchant_member_id' => '',
            'merchant_amount' => 0,
        ];
        $employeePreData = [
            'employee_member_id' => '',
            'employee_amount' => 0,
        ];

        $hfCompanyMObj = [];
        //商户是否实名
        $isMerchantRealName = 0;
        if ($merchant_id) {
            $hfCompanyMObj = HfCompanyMember::where('merchant_id', $merchant_id)->first();
            $isMerchantRealName = ($hfCompanyMObj->status == 'succeeded') ? 1 : 0;
        }

        //查询用户绑定的员工
        $employee = DB::table('store_employee_user_rec')
            ->where('user_id', $buyer_id)
            ->first();

        $hfEmployeeMObj = [];
        //员工是否实名
        $isEmployeeRealName = 0;
        if ($employee) {
            $employeeObj = StoreAdminUsers::find($employee->employee_id);

            //打印分账员工
            Log::add('divide', "订单ID:{$order_id}，分账员工:{$employeeObj->name}");

            $hfEmployeeMObj = HfSettleAccount::whereNull('deleted_at')
                ->where('mid', $employeeObj->id)
                ->first();
            $isEmployeeRealName = ($hfEmployeeMObj) ? 1 : 0;
        }

        Log::add('divide', "实名情况：isMerchantRealName:{$isMerchantRealName};isEmployeeRealName:{$isEmployeeRealName}");

        $ogList = OrderGoods::where("order_id", $order_id)->get(); //订单商品

        $cash_ratio = 1; //现金支付比例，默认100%
        //判断支付类型，纯现金还是现金+积分，计算订单内商品金额与实付金额比例，最终分佣为实付金额的比例
        if ($orderObj->pay_type == 1) { //纯现金支付
            $cash_ratio = 1;
        } else if ($orderObj->pay_type == 3) { //混合支付(现金+积分)
            //计算订单商品总金额(单价*数量)
            $orderGoodCash = OrderGoods::where("order_id", $order_id)
                ->select(DB::raw('SUM(goods_price * goods_number) as total'))
                ->value('total');
            //计算现金支付比例
            $cash_ratio = number_format(($orderObj->order_amount / $orderGoodCash), 4); //保留4位小数
        }

        Log::add('divide', "订单ID:{$order_id}，支付类型:{$orderObj->pay_type}，现金支付比例:{$cash_ratio}");

        foreach ($ogList as $kk => $item) {
            $goods_amount = $item->goods_price * $item->goods_number;
            $total_amount +=  number_format($goods_amount*$cash_ratio,2);
            //商品信息
            $goodObj = Good::find($item->goods_id);
            $merchant_commission = $goodObj->merchant_commission;
            $merchant_proportion .= $goodObj->merchant_commission . ",";
            $sp_ogid = $item->id . ",";

            //应该分给商家的金额
            $merchant_divide_price = number_format($goods_amount * ($merchant_commission / 100) * $cash_ratio, 2);
            $employee_divide_price = 0;
            $employee_divide_price_log = $merchant_divide_price;

            //应该分给商家的金额
            //Log::add('divide', "员工分佣:{$employeeObj->employee_commission}");

            //员工分佣记录
            if ($employee && $employeeObj->employee_commission >= 1 && $employeeObj->employee_commission < 100) {

                // 基于商家分到佣金计算员工分佣
                $employee_divide_price = number_format($merchant_divide_price * ($employeeObj->employee_commission / 100), 2);
                $employeePreData['employee_amount'] += $employee_divide_price;
                $employeePreData['employee_member_id'] = $employeeObj->member_id;

                
                //应该分给员工的金额
                Log::add('divide员工', "员工比例:{$employeeObj->employee_commission}， 员工分佣:{$employee_divide_price}， 商户分佣:{$merchant_divide_price}");
            }

            //商户分佣记录
            if ($merchant_id && $merchant_commission >= 1 && $merchant_commission < 100) {
                $merchant_divide_price = $merchant_divide_price - $employee_divide_price;

                $commissionPreData['merchant_amount'] += $merchant_divide_price;
                $commissionPreData['merchant_member_id'] = $hfCompanyMObj->member_id;
            }

            //应该分给商家的金额
            Log::add('divide商家', "，应该分给商家的金额:{$employee_divide_price_log}， 员工分佣:{$employee_divide_price}， 商户分佣:{$merchant_divide_price}");
        }

        //商户佣金
        if ($merchant_id && $merchant_commission >= 1 && $merchant_commission < 100 && $commissionPreData['merchant_amount'] > 0) {
            self::addRecord($sp_ogid, $order_id, $orderObj->goods_amount, $commissionPreData['merchant_amount'], $merchant_proportion, $merchant_id, $buyer_id, 3, $isMerchantRealName, $payconfirm_no);
            if ($isMerchantRealName) {
                array_push($div_members, ['member_id' => $commissionPreData['merchant_member_id'], 'amount' => sprintf("%.2f", $commissionPreData['merchant_amount']), 'fee_flag' => 'N']);
            }
        }

        //员工佣金
        if ($employee && $employeePreData['employee_amount'] > 0) {
            self::addRecord($sp_ogid, $order_id, $orderObj->goods_amount, $employeePreData['employee_amount'], $employeeObj->employee_commission, $employeeObj->member_id, $buyer_id, 5, $isEmployeeRealName, $payconfirm_no);
            if ($isEmployeeRealName) {
                array_push($div_members, ['member_id' => $employeePreData['employee_member_id'], 'amount' => sprintf("%.2f", $employeePreData['employee_amount']), 'fee_flag' => 'N']);
            }
        }

        //平台本身
        $aimeiyuePrice = $total_amount - $commissionPreData['merchant_amount'] - $employeePreData['employee_amount'];
        self::addRecord($sp_ogid, $order_id, $orderObj->goods_amount, $aimeiyuePrice, '', 0, $buyer_id, 0, 1, $payconfirm_no);
        array_push($div_members, ['member_id' => 0, 'amount' => sprintf("%.2f", $aimeiyuePrice), 'fee_flag' => 'Y']);

        //确认分佣金额
        if (!$isMerchantRealName) {
            $commissionPreData['merchant_amount'] = 0;
        }
        if (!$isEmployeeRealName) {
            $employeePreData['employee_amount'] = 0;
        }
        $confirm_amt = $aimeiyuePrice + $commissionPreData['merchant_amount'] + $employeePreData['employee_amount'];
        return ['div_members' => $div_members, 'confirm_amt' => sprintf("%.2f", $confirm_amt)];
    }

    /**
     * 新增分账记录
     * @param string $og_id 订单商品ID
     * @param int $order_id 订单ID
     * @param float $goods_amount 商品金额
     * @param float $divide_price 分账金额
     * @param string $commission 佣金比例
     * @param int $um_id 用户或商户ID
     * @param int $buyer_id 买家ID
     * @param int $sh_type 分账类型 推送类型 0:平台 1:直推 2:间推 3:商户 4:手动分账 5:员工
     * @param int $isExistAccount 是否实名
     * @param string $payconfirm_no 支付确认编号
     */
    public static function addRecord($og_id, $order_id, $goods_amount, $divide_price, $commission = '', $um_id = 0, $buyer_id, $sh_type = 0, $isExistAccount, $payconfirm_no)
    {
        $recordObj = new self();
        $recordObj->order_id = $order_id;
        $recordObj->user_id = $buyer_id;
        $recordObj->og_id = trim($og_id, ',');
        $recordObj->order_price = $goods_amount;
        $recordObj->divide_price = $divide_price;
        $recordObj->proportion = trim($commission, ',');
        $recordObj->um_id = $um_id;
        $recordObj->sh_type = $sh_type;
        $recordObj->is_div = $isExistAccount ? 1 : 0; //是否分账
        $recordObj->payconfirm_no = $isExistAccount ? $payconfirm_no : '';
        $recordObj->save();
        Log::add('订单分佣记录', $recordObj->toArray());
    }

    public function order()
    {
        return $this->belongsTo(OrderInfo::class, 'order_id', 'id');
    }

    public function users()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
