<?php

use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;
use Dcat\Admin\Admin;

Admin::routes();

Route::group([
    'prefix'     => config('admin.route.prefix'),
    'namespace'  => config('admin.route.namespace'),
    'middleware' => config('admin.route.middleware'),
], function (Router $router) {

    /******************************************************  图片文件上传组件Start  *********************************************************/
    $router->match(['put', 'post'], 'upload/delete-oss-file', 'UploadController@deleteOssFile'); //删除OSS私有资源文件

    $router->match(['put', 'post'], 'upload/delete-public-oss-file', 'UploadController@deletePublicOssFile'); //删除OSS公有资源文件

    //$router->match(['put', 'post'], 'upload/goods', 'UploadController@uploadResourceImg'); //上传资源图

    $router->match(['put', 'post'], 'upload/user', 'UploadController@userUpload'); //头像图上传

    $router->match(['put', 'post'], 'upload/goods', 'UploadController@goodsUpload'); //商品图上传

    $router->match(['put', 'post'], 'upload/merchant', 'UploadController@merchantUpload'); //门店图上传

    $router->match(['put', 'post'], 'upload/user-avatar', 'UploadController@uploadUserAvatar'); //上传用户头像

    $router->match(['put', 'post'], 'upload/carousel', 'UploadController@carouselUpload'); //上传轮播图

    $router->match(['put', 'post'], 'upload/huifu', 'UploadController@huifuUpload'); //上传汇付平台图片

    $router->match(['put', 'post'], 'upload/article', 'UploadController@articleUpload'); //上传文章图

    $router->match(['put', 'post'], 'upload/skuImage', 'UploadController@uploadSkuImage'); //上传商品规格图

    //$router->match(['put', 'post'], 'upload/resource-file', 'UploadController@uploadResourceFile'); //上传资源文件

    /******************************************************  图片文件上传组件end    *********************************************************/


    $router->get('/', 'HomeController@index');

    $router->resource('category', 'CategoryController'); //分类管理

    $router->resource('bill-down', 'HfBillDownController'); //对账单下载-页面
    $router->get('bill-down-download','HfBillDownController@download'); //对账单下载-下载

    $router->resource('article', 'ArticleController'); //文章管理

    $router->resource('goods', 'GoodController'); //商品管理

    $router->resource('kefu', 'KefuController');  //平台客服

    $router->resource('setting', 'SystemSettingController'); //数值设置

    $router->resource('orderInfo', 'OrderInfoController'); //订单管理
    $router->post('order-refund', 'OrderInfoController@OrderAdminRefund'); // 添加退款路由

    $router->resource('order-divide-record', 'OrderDivideRecordController'); //订单分佣记录

    $router->resource('user', 'UserController');  //用户管理

    $router->resource('user-share', 'ShareController');  //查看下级

    $router->resource('carousel', 'CarouselController');  //轮播图管理

    $router->resource('merchant', 'MerchantController');  //商家管理

    $router->resource('merchant-store', 'MerchantGoodsStoreController');  //商家库存管理

    $router->resource('merchant-store-log', 'MerchantStoreSkuLogController');  //商家库存记录

    $router->resource('buycode-check', 'UserBuycodeCheckController');  //直购码审核

    $router->resource('verifier', 'StoreAdminUsersController');  //核销员列表
    $router->resource('employee', 'StoreAdminEmployeeController');  //员工列表

    $router->resource('comment', 'CommentController');  //评论列表

    $router->resource('comment-tpl', 'CommentTplController');  //评价模板

    $router->resource('check-cashout', 'IncomeController');  //提现审核管理

    $router->get('city', 'CityController@getList');  //城市选择-联动

    $router->get('hf-area-code', 'HfProvAreaCodeController@getList');  //汇付城市编码-联动

    $router->get('get-store-list', 'MerchantGoodsStoreController@getList');  //门店选择-联动

    $router->resource('hf-company-member', 'HfCompanyMemberController');  //汇付天下-企业用户

    
    $router->resource('user-point-change-rec', 'UserPointChangeRecController');  //积分记录
    $router->resource('payment-record', 'PaymentRecordController');  //支付记录
    $router->resource('hf-settle-account', 'HfSettleAccountController');  //汇付普通用户

});
