<?php

namespace App\Admin\Controllers;

use App\Models\StoreAdminUsers;
use App\Models\Merchant;
use App\Models\Good;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Illuminate\Support\Facades\Hash;
use Dcat\Admin\Http\Controllers\AdminController;
use Illuminate\Support\Facades\DB;
use App\Models\Adapay;

class StoreAdminEmployeeController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(StoreAdminUsers::with(['merchant', 'store']), function (Grid $grid) {
            $grid->model()->where('role_id', 3); //3: 员工
            $grid->model()->orderBy('created_at', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('name', '姓名');
            $grid->column('phone', '手机号');
            $grid->column('username', '登录账号');
            $grid->column('merchant.name', '所属商家');
            $grid->column('store.title', '所属门店');
            $grid->column('employee_commission', '员工返佣比例');
            $grid->column('member_id', '汇付用户ID');
            $grid->column('created_at', '创建时间');
            // $grid->column('created_at');
            // $grid->column('updated_at')->sortable();
            $grid->disableViewButton();
            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('name', '姓名')->width(3);
                $filter->like('username', '登录账号')->width(3);
                $filter->like('merchant.name', '所属商家')->width(3);
                $filter->like('store.title', '所属门店')->width(3);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        // return Show::make($id, new Verifier(), function (Show $show) {
        //     $show->field('id');
        //     $show->field('merchant_id');
        //     $show->field('store_id');
        //     $show->field('created_at');
        //     $show->field('updated_at');
        // });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form =  Form::make(new StoreAdminUsers(), function (Form $form) {
            $form->display('id');
            //$form->ignore(['pwd']); // 忽略password字段
            $form->text('name')->required();
            // 手机号字段 - 创建时显示，编辑时隐藏
            if ($form->isCreating()) {
                $form->text('phone', '手机号')->required();
            } else {
                $form->hidden('phone');
                //$form->text('phone', '手机号')->required();
            }


            $form->text('username', '登录账号')
                ->required()
                ->help('字母数字组合，长度大于5个字符')
                ->rules(function (Form $form) {
                    /**
                     * 用户名唯一性验证规则
                     * 功能：验证用户名是否已存在
                     * 参数：$form 表单实例
                     * 返回值：string 验证规则字符串
                     * 注意事项：编辑时排除当前记录
                     */
                    $rule = 'unique:store_admin_users,username';
                    if ($id = $form->model()->id) {
                        $rule .= ',' . $id;
                    }
                    return $rule;
                }, [
                    'unique' => '该登录账号已被使用，请更换'
                ]);
            if ($form->isCreating()) {
                $form->password('password', '密码')->saving(function ($password) {
                    return bcrypt($password);
                })->help('字母数字组合，长度大于5个字符');
                // } else {
                //     $form->text('password', '密码')->help('密码为空则不修改');
                //     $form->password = '';
            }
            if ($form->isEditing()) {
                $form->text('pwd', '密码')->help('密码为空则不修改');
            }
            $form->text('employee_commission', '员工返佣比例')->help("在商家佣金中的比例，如：20")->required();


            $form->hidden('role_id')->default(3); //员工
            // 如果是创建模式，执行相关操作
            $form->select('merchant_id', '商家名称')
                ->options(Merchant::whereNull('deleted_at')->get()->pluck('name', 'id'))
                ->load('store_id', '/get-store-list');
            $form->select('store_id', '门店名称');

           
            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();
        });

        //副表保存规格
        $form->saved(
            function (Form $form, $result) {
                $store_admin_users_id = $form->getKey();
                $pwd = $form->model()->pwd;
                //更新信息
                if ($pwd) {
                    $data = ['password' => bcrypt($pwd), 'pwd' => ''];
                    DB::table('store_admin_users')->where("id", $store_admin_users_id)->update($data);
                }

                // 创建汇付账户逻辑
                $user = StoreAdminUsers::find($store_admin_users_id);
                if ($user && !$user->member_id) {
                    $result = (new Adapay())->createMember($user->id, $user->phone);
                    if (isset($result['status']) && $result['status'] == 'succeeded') {
                        $user->member_id = $result['member_id'];
                        $user->save();
                    }
                }
            }
        );

        // //对接汇付-创建个人对象【员工绑定银行卡再创建】
        // if (!$form->member_id) {
        //     $result = (new Adapay())->createMember($form->display('id'), $user->phone);
        //     if (isset($result['status']) && $result['status'] == 'succeeded') {
        //         DB::table('users')->where('id', $user->id)->update(['member_id' => $result['member_id']]);
        //     }
        // }

        return $form;
    }
}
