<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Default Filesystem Disk
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default filesystem disk that should be used
    | by the framework. The "local" disk, as well as a variety of cloud
    | based disks are available to your application. Just store away!
    |
    */
    //'default' => env('FILESYSTEM_DISK', 'cos'),
    'default' => env('FILESYSTEM_DISK', 'public_oss'),

    /*
    |--------------------------------------------------------------------------
    | Filesystem Disks
    |--------------------------------------------------------------------------
    |
    | Here you may configure as many filesystem "disks" as you wish, and you
    | may even configure multiple disks of the same driver. Defaults have
    | been set up for each driver as an example of the required values.
    |
    | Supported Drivers: "local", "ftp", "sftp", "s3"
    |
    */

    'disks' => [

        'local' => [
            'driver' => 'local',
            'root' => storage_path('app'),
            'throw' => false,
        ],

        'public_oss' => [
            'driver' => 'oss',
            'access_id'  => env('OSS_ACCESS_KEY_ID'), //Your Aliyun OSS AccessKeyId
            'access_key' => env('OSS_ACCESS_KEY_SECRET'), //Your Aliyun OSS AccessKeySecret
            'bucket'     => env('OSS_PUBLIC_BUCKET'), //OSS bucket name
            'endpoint'   => env('OSS_ENDPOINT'),
            'ssl'        => false,
            'debug'      => true,
        ],
        'admin'  => [
            'driver'     => 'local',
            'root'       => public_path('uploads'),
            'visibility' => 'public',
            'url'        => env('IMAGE_URL', ''),
        ],
        'public' => [
            'driver' => 'local',
            'root' => storage_path('app/public'),
            'url' => env('APP_URL') . '/storage',
            'visibility' => 'public',
            'throw' => false,
        ],

        's3' => [
            'driver' => 's3',
            'key' => env('AWS_ACCESS_KEY_ID'),
            'secret' => env('AWS_SECRET_ACCESS_KEY'),
            'region' => env('AWS_DEFAULT_REGION'),
            'bucket' => env('AWS_BUCKET'),
            'url' => env('AWS_URL'),
            'endpoint' => env('AWS_ENDPOINT'),
            'use_path_style_endpoint' => env('AWS_USE_PATH_STYLE_ENDPOINT', false),
            'throw' => false,
        ],
        'cos' => [
            'driver'  => 'cos',
            'region'  => env('COS_REGION'),
            'secretId' => env('COS_SECRET_ID'),
            'secretKey' => env('COS_SECRET_KEY'),
            'bucket'  => env('COS_BUCKET'),
            'read_from_cdn' => false, // 是否从CDN读取数据
            'cdn'  => '', // 你的CDN域名，例如：'http://cdn.example.com/'
            'scheme'  => 'https',
            'domain'  => '', // 自定义域名，如果为空则使用COS提供的域名
            'prefix'  => '', // 文件前缀，可用于文件分类
            'request'  => [
                'timeout' => 60,
            ],
        ],


    ],

    /*
    |--------------------------------------------------------------------------
    | Symbolic Links
    |--------------------------------------------------------------------------
    |
    | Here you may configure the symbolic links that will be created when the
    | `storage:link` Artisan command is executed. The array keys should be
    | the locations of the links and the values should be their targets.
    |
    */

    'links' => [
        public_path('storage') => storage_path('app/public'),
    ],

];
