<?php

namespace App\Store\Metrics\Examples;


use App\Models\StoreOrder;
use Dcat\Admin\Widgets\Metrics\Line;
use Illuminate\Http\Request;

class StoreOrderChats  extends Line
{
    /**
     * 初始化卡片内容
     *
     * @return void
     */
    protected function init()
    {
        parent::init();

        $this->title('已完成订单');
        $this->dropdown([
            '7' => '最近7天',
            '30' => '最近30天',
            '365' => '最近一年',
        ]);
        $this->height(600);
        $this->chartHeight(500);
        $this->chartOptions = [
            'colors' =>['#FF69B4'],
            'chart' => [
                'type' => 'area',

                'dropShadow' => [
                    'enabled' => true,
                    'color' => '#000',
                    'top' => 18,
                    'left' => 7,
                    'blur' => 10,
                    'opacity' => 0.2
                ],
                'toolbar' => [
                    'show' => false
                ],
                'zoom' => [
                    //关闭缩放
                    'enabled' => false
                ]
            ],
            'stroke' => [
                'show' => true,
                'width' => 1,
                'colors' => ['#77B6EA'],
                'curve' => 'smooth'
            ],
//            'fill' => [
//                'type' => 'gradient',
//                'gradient'=>[
//                    'opacityFrom' => 0.6,
//                    'opacityTo'=> 0.8
//                ]
//            ],

            'grid' => [
                'borderColor' => '#e7e7e7',
                'row' => [
                    'opacity' => 0.5
                ],
            ],
            //圆点大小
            'markers' => [
                'size' => 0
            ],
            'dataLabels' => [
                'enabled' => false,
                'offsetX' => 0,
                'style' => [
                    'fontSize' => '12px',
                    'colors' => ['#FFFFFF']
                ]
            ],
            'plotOptions' => [
                'line' => [
                    'horizontal' => true,
                    'dataLabels' => [
                        'position' => 'top',
                    ],
                ]
            ],
            'xaxis' => [
                'categories' => [],
            ],
        ];

    }

    /**
     * 处理请求
     *
     * @param Request $request
     *
     * @return mixed|void
     */
    public function handle(Request $request)
    {
        switch ($request->get('option')) {
            case '365':
                $data = StoreOrder::getYearOrder();
                // 卡片内容
                $this->withContent('总量: '.$data['total']);
                // 图表数据
                $this->withChart($data['list']);
                break;
            case '30':
                $data = StoreOrder::getNumDayOrder(30);
                // 卡片内容
                $this->withContent('总量: '.$data['total']);
                // 图表数据
                $this->withChart($data['list']);
                break;
            case '7':
            default:
                $data = StoreOrder::getNumDayOrder(7);
                // 卡片内容
                $this->withContent('总量: '.$data['total']);
                // 图表数据
                $this->withChart($data['list']);
        }
    }

    /**
     * 设置图表数据.
     *
     * @param array $data
     *
     * @return $this
     */
    public function withChart(array $data)
    {

        $days = [];
        $order_data = [
        ];
        foreach ($data as $k=>$v){
            $days[] = $k;
           $order_data[] = $v;
        }

        return $this->chart([
            'series' => [
                [
                    'name' =>'完成订单',
                    'data' =>$order_data
                ],
            ],
            'xaxis' => [

                'categories'=> $days
            ],



        ]);
    }

    /**
     * 设置卡片内容.
     *
     * @param string $content
     *
     * @return $this
     */
    public function withContent($content)
    {
        return $this->content(
            <<<HTML
<div class="d-flex justify-content-between align-items-center mt-1" style="margin-bottom: 2px">
    <h2 class="ml-1 font-lg-1">{$content}</h2>
    <span class="mb-0 mr-1 text-80">{$this->title}</span>
</div>
HTML
        );
    }
}
