<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\SoftDeletes;
use Dcat\Admin\Traits\HasDateTimeFormatter;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;
    use HasDateTimeFormatter;
    use SoftDeletes;


    public const USER_STATUS = [
        0 => '审核中',
        1 => '正常',
        2 => '驳回'
    ];

    //分享人信息
    public function shuser()
    {
        return $this->belongsTo(User::class, 'spuid');
    }

    

    //获取指定天数注册数
    public static function getNumDayData($dayNum)
    {
        $days = [date('Y-m-d')];
        for ($i = 1; $i < $dayNum; $i++) {
            $days[] = date("Y-m-d", strtotime("-$i day"));
        }
        $days = array_reverse($days);
        $data = [
            'total' => 0,
            'list' => []
        ];
        foreach ($days as $day) {
            $startTime = $day . ' 00:00:00';
            $endTime = $day . ' 23:59:59';
            $count = self::whereBetween('created_at', [$startTime, $endTime])->count();
            $data['list'][$day] = $count;
            $data['total'] += $count;
        }
        return $data;
    }


    //获取最近一年的注册人数
    public static function getYearData()
    {
        $y = date('Y');
        $m = date('m');

        for ($i = 1; $i <= $m; $i++) {
            $days[] = $y . '-' . $i;
        }
        $data = [
            'total' => 0,
            'list' => []
        ];

        foreach ($days as $day) {
            $startTime = $day . '-01 00:00:00';
            $m_max_day = date('t', strtotime($startTime));
            $endTime = $day . '-' . $m_max_day . ' 23:59:59';
            $count = self::whereBetween('created_at', [$startTime, $endTime])->count();
            $data['list'][$day] = $count;
            $data['total'] += $count;
        }
        return $data;
    }

    public function getCustomFieldOptionsAttribute()
    {
        // 这里你可以自定义查询来获取你想要的option值
        // 例如从关联表或者缓存中获取
        return [
            'option1' => '显示值1',
            'option2' => '显示值2',
            // 更多选项...
        ];
    }
}
