<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class MerchantStoreSkuLog extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;
    protected $table = 'merchant_store_sku_log';

    public function goods()
    {
        return $this->belongsTo(Good::class, 'goods_id');
    }

    public function attr()
    {
        return $this->belongsTo(GoodSku::class, 'attr_id');
    }

    public function mergs()
    {
        return $this->belongsTo(MerchantStore::class, 'mgs_id');
    }
}
