<?php

namespace App\Jobs;

use App\Command\Log;
use App\Models\OrderDivideRecord;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

class AutoCompleteOrder implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $order;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($order, $delay)
    {
        $this->order = $order;
        // 设置延迟的时间，delay() 方法的参数代表多少秒之后执行
        $this->delay($delay);
    }

    /**
     * * 定义这个任务类具体的执行逻辑
     * 当队列处理器从队列中取出任务时，会调用 handle() 方法
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        if ($this->order->order_status != 3) { //待评价
            return;
        }
        // 通过事务执行 sql
        DB::beginTransaction();
        try {
            $this->order->order_status = 4; //已完成
            $this->order->save();



            DB::commit();
            Log::add('订单自动完成', $this->order->toArray());
        } catch (\Exception $exception) {
            DB::rollBack();
            Log::add('自动完成订单失败', $exception);
        }
    }
}
