<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Command\Tools; // 引入 Tools 类
use App\Handlers\FileUploadHandler;
use App\Models\Carousel;
use App\Models\GoodSku;
use App\Models\Good;
use App\Models\Merchant;
use App\Models\User;
use App\Models\UserAddress;
use App\Models\OrderDivideRecord;
use App\Models\UserPointChangeRec;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class UserController extends BaseController
{

    //加入购物车
    public function addShoppingCart(Request $request)
    {
        $userObj = $request->user();
        $merchant_id = $userObj->merchant_id;
        $goods_id = $request->goods_id ?? 0;
        $num = $request->num ?? 0;
        $attr_name = $request->attr_name ? trim($request->attr_name) : '';
        //商品信息
        $goodsObj = Good::where("id", $goods_id)->first();
        Log::add('添加购物车商品信息===' . $goods_id, []);
        if (!$goodsObj) {
            return $this->JsonResponse('', '该商品已下架', 500);
        }
        $goods_price = 0;
        //处理规格
        $attr_id = 0;
        $attr_sn = $attr_txt = '';
        if ($attr_name) {
            $attrArr = explode(",", $attr_name);
            utf8_array_asort($attrArr);
            $attrStr = join("、", $attrArr);
            $attr_sn = md5($attrStr);

            $goodsAttrObj = GoodSku::where("goods_id", $goods_id)->where("attr_sn", $attr_sn)->first();
            if (!$goodsAttrObj) {
                return $this->JsonResponse('', '该规格参数有误，选择其它规格', 500);
            }
            Log::add('添加购物车商品规格', $goodsAttrObj->toArray());
            $attr_id = $goodsAttrObj->id;
            $attr_txt = $goodsAttrObj->attr_val;
            $goods_price = ($merchant_id && $goodsObj->goods_type) ? $goodsAttrObj->cg_price : $goodsAttrObj->market_price;
        }

        $shoppingCart = isset($userObj->shopping_cart) ? json_decode($userObj->shopping_cart, true) : [];

        $key = $goods_id . "_" . $attr_sn;
        if (isset($shoppingCart[$key]) && $shoppingCart[$key]['attr_sn'] == $attr_sn) {
            $count = $shoppingCart[$key]['num'] + $num;
            $shoppingCart[$key] = [
                'goods_id' => $goods_id,
                'attr_id' => $attr_id,
                'num' => $count,
                'attr_sn' => $attr_sn,
                'attr_txt' => $attr_txt,
                'goods_price' => $goods_price,
            ];
        } else {
            $shoppingCart[$key] = [
                'goods_id' => $goods_id,
                'attr_id' => $attr_id,
                'num' => $num,
                'attr_sn' => $attr_sn,
                'attr_txt' => $attr_txt,
                'goods_price' => $goods_price,
            ];
        }
        //
        $resultCart = empty($shoppingCart) ? null : json_encode($shoppingCart, JSON_UNESCAPED_UNICODE);

        $userObj->shopping_cart = $resultCart;
        $userObj->save();

        return  $this->JsonResponse('');
    }

    //购物车详情
    public function showShoppingCart(Request $request)
    {
        $userObj = $request->user();
        $shoppingCart = isset($userObj->shopping_cart) ? json_decode($userObj->shopping_cart, true) : [];

        $data = [];
        if ($shoppingCart) {
            foreach ($shoppingCart as $key => $item) {
                $tmp = [];
                $goodsAttrObj = GoodSku::where("goods_id", $item['goods_id'])->where("attr_sn", $item['attr_sn'])->first();
                $goodsObj = Good::where("id", $item['goods_id'])->where('is_show', 1)->first();
                if (!$goodsAttrObj || !$goodsObj) {
                    unset($shoppingCart[$key]);
                    continue;
                }
                $tmp['catKey'] = $item['goods_id'] . "_" . $item['attr_sn'];
                $tmp['goods_id'] = $item['goods_id'];
                $tmp['goods_name'] = $goodsObj->goods_name;
                $tmp['cover_img'] =  $goodsObj->cover_img  ;
                $tmp['num'] = $item['num'];
                $tmp['attr_sn'] = $item['attr_sn'];
                $tmp['goods_price'] = $item['goods_price'];
                $tmp['attr_name'] = $item['attr_txt'];

                array_push($data, $tmp);
            }
            $userObj->shopping_cart = empty($shoppingCart) ? null : json_encode($shoppingCart, JSON_UNESCAPED_UNICODE);
            $userObj->save();
        }
        return $this->JsonResponse($data);
    }

    //删减减购物车商品
    public function reduceShoppingCart(Request $request)
    {
        $cartKey = $request->cartKey ?? '';
        $user = $request->user();
        $shoppingCart = isset($user->shopping_cart) ? json_decode($user->shopping_cart, true) : [];
        if (empty($shoppingCart)) {
            return $this->JsonResponse('', '购物车无资源', 500);
        }
        if ($cartKey) {
            $ckeys = explode(',', $cartKey);
            foreach ($ckeys as $kk => $vv) {
                if (isset($shoppingCart[$vv])) unset($shoppingCart[$vv]);
            }
        }
        $user->shopping_cart = empty($shoppingCart) ? null : json_encode($shoppingCart, JSON_UNESCAPED_UNICODE);
        $user->save();
        return $this->JsonResponse('');
    }

    //购物车商品数量更新
    public function numberShoppingCart(Request $request)
    {
        $cart_id = $request->cartKey ?? '';
        $number = $request->num ?? 0;
        $user = $request->user();
        $shoppingCart = $user->shopping_cart ? json_decode($user->shopping_cart, true) : [];
        if (empty($shoppingCart)) {
            return $this->JsonResponse('', '购物车无资源', 201);
        }
        foreach ($shoppingCart as $key => $val) {
            if (isset($shoppingCart[$cart_id])) {
                if ($number) {
                    $shoppingCart[$cart_id]['num'] = $number;
                } else {
                    unset($shoppingCart[$cart_id]);
                }
            }
        }

        $user->shopping_cart = empty($shoppingCart) ? null : json_encode($shoppingCart, JSON_UNESCAPED_UNICODE);
        $user->save();
        return $this->JsonResponse('');
    }

    public function info(Request $request)
    {
        $user = $request->user();
        $merchant_id = $user->merchant_id ?? 0;
        $user_id = $user->id ?? 0;

        //计算冻结中、解冻中的积分
        $frozen_balance = UserPointChangeRec::where('user_id', $user_id)->where('change_type', 1)->where('point_state', 3)->sum('point_amount');
        $thawing_balance = UserPointChangeRec::where('user_id', $user_id)->where('change_type', 1)->where('point_state', 2)->sum('point_amount');

        $balance = number_format($user->balance, 2, '.', ''); // 余额
        $frozen_balance = number_format($frozen_balance, 2, '.', ''); // 冻结中
        $thawing_balance = number_format($thawing_balance, 2, '.', ''); // 解冻中

        return $this->JsonResponse([
            'user_id' => $user->id,
            'nickname' => $user->name,
            'avatar' => $user->avatar ? env('IMAGE_URL') . $user->avatar : env('NO_AVATAR_IMAGE_URL'),
            'phone' => $user->phone,
            'phone_sec' => $user->phone ? substr($user->phone, 0, 3) . "****" . substr($user->phone, 7) : '',
            //'status' => $user->status,
            'merchant_id' => $merchant_id,
            'buycode' => $user->buycode ?? '',
            'balance' => $balance ?? 0, // 可用积分余额
            'frozen_balance' => $frozen_balance ?? 0, // 冻结中的积分
            'thawing_balance' => $thawing_balance ?? 0 // 解冻中的积分
        ]);
    }

    public function home(Request $request)
    {
        $carousel = Carousel::where(['status' => 1])->select(['imgUrl', 'linkUrl', 'descr'])->get();
        $user_per = $request->user()->permissions ? json_decode($request->user()->permissions, true) : [];
        $permission_ids = array_intersect([1, 2, 3, 4, 5], $user_per);
        $permission = [];
        if (!empty($permission_ids)) {
            foreach ([1, 2, 3, 4, 5] as $item) {
                if (in_array($item, $user_per)) {
                } else {
                    $permission[] = [
                        'name' => '',
                        'slug' => ''
                    ];
                }
            }
            //            foreach ($permission_ids as $id){
            //                $u_p = UserPermission::find($id);
            //                $permission[] = [
            //                    'name' => $u_p->name,
            //                    'slug' => $u_p->slug
            //                ];
            //            }
        }
        return $this->JsonResponse(['carousel' => $carousel, 'permissions' => $permission]);
    }



    //图片统一上传接口
    public function uploadImg(FileUploadHandler $fileUploadHandler, Request $request)
    {
        $imgFile = $request->img_file ?? null;
        if (empty($imgFile)) {
            return $this->JsonResponse('', '参数异常', 201);
        }
        $imgUrl = $fileUploadHandler->save($imgFile);
        if (!$imgUrl) {
            return $this->JsonResponse('', '上传失败', 201);
        }
        return $this->JsonResponse(['img_url' => $imgUrl]);
    }

    //更新用户
    public function editUser(Request $request)
    {
        $name  = $request->name ?? '';
        $avatar = $request->avatar ?? null;
        $user = $request->user();
        if ($name) {
            $user->name = $name;
        }
        if (stripos($avatar, 'wximg') !== false) {
            $avatar = '';
        }
        if ($avatar) {

            // if (is_file(public_path() . '/uploads' . $user->avatar)) {
            //     unlink(public_path() . '/uploads' . $user->avatar);
            // }

            $user->avatar = $avatar ? str_replace(env('IMAGE_URL'), '', $avatar) : '';
        }

        if ($name) {
            $user->save();
        }

        return $this->JsonResponse([
            'id' => $user->id,
            'name' => $user->name,
            'avatar' => ($user->avatar ? env('IMAGE_URL') . $user->avatar : '')
        ]);
    }

    //修改密码
    public function updatePwd(Request $request)
    {
        $phone = $request->phone ?? '';
        $captcha = $request->code ?? '';
        $password = $request->pwd ?? '';
        $event = $request->event ?? 'pwd';

        if (!$phone || !$captcha) {
            return $this->JsonResponse('', '账号或验证码不为空', 500);
        }

        if (!$this->checkcode($phone, $captcha, $event)) {
            return $this->JsonResponse('', '验证码错误或已过期', 500);
        }

        $user = User::where('phone', $phone)->where('status', 1)->first();
        if (!$user) {
            return $this->JsonResponse('', '用户不存在或已被禁用', 500);
        }
        if (strlen($password) < 6) {
            return $this->JsonResponse('', '密码长度不低于6个字符', 500);
        }

        $user->password = Hash::make($password);
        $res = $user->save();
        if ($res) {
            // 删除验证码
            $this->flush($phone, 'login');
        }
        return $this->JsonResponse('');
    }

    //上传文件
    public function uploadFile(FileUploadHandler $fileUploadHandler, Request $request)
    {
        $file = $request->file_obj ?? null;
        $file_path = '';
        if ($file) {
            $file_path = Env('IMAGE_URL') . $fileUploadHandler->save($file);
        }
        return $this->JsonResponse($file_path);
    }

    //获取收货地址列表
    public function getUserAddress(Request $request)
    {
        $list = UserAddress::where(['uid' => $request->user()->id, 'deleted_at' => null])->limit(10)->get();
        foreach ($list as $key => $item) {
            $list[$key]['area'] = $item->province ? $item->province . " " . $item->city . " " . $item->district : "";
        }
        return $this->JsonResponse($list);
    }

    //设置收货地址
    public function setUserAddress(Request $request)
    {
        $address_id = $request->address_id ?? 0;
        $consignee = $request->consignee ?? '';
        $phone = $request->phone ?? '';
        $area = $request->area ?? '';
        $address = $request->address ?? '';
        $is_default = $request->is_default ?? 0;
        $model = UserAddress::find($address_id);
        if (!$model) {
            $model = new UserAddress();
        } elseif ($model->uid != $request->user()->id) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        $model->uid = $request->user()->id;
        $count = UserAddress::where('uid', $model->uid)->get()->count();
        if ($count > 10) {
            return $this->JsonResponse('', '收货地址总数在10条以内', 500);
        }
        if ($consignee) $model->consignee = $consignee;
        if ($phone) $model->phone = $phone;
        if ($area) $model->area = $area;
        if ($address) $model->address = $address;

        if ($is_default !== null) {
            $model->is_default = $is_default;
            if ($is_default == 1) {
                UserAddress::where(['uid' => $request->user()->id])->update(['is_default' => 0]);
            }
        }
        if (!$model->save()) {
            return $this->JsonResponse('', '设置收货地址失败', 201);
        }
        return $this->JsonResponse($model->toArray());
    }

    //删除收货地址
    public function delUserAddress(Request $request)
    {
        $address_id = $request->address_id ?? null;
        if (!$address_id) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        $address_ids = explode(',', $address_id);
        UserAddress::where(['uid' => $request->user()->id])->whereIn('id', $address_ids)->delete();
        return $this->JsonResponse('');
    }


    //用户分享
    public function share(Request $request)
    {
        $shuid = $request->spuid ?? 0;
        $spObj = User::find($shuid);
        if (!$spObj) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        //分享人注册时间
        $sp_time = strtotime($spObj->created_at);

        $userObj = $request->user();
        $user_time = strtotime($userObj->created_at);

        //用户注册时间大于分享人注册时间 才可以分享
        Log::add('share', '分享人注册时间:' . $sp_time . ';当前用户注册时间：' . $user_time, $request);
        if ($user_time > $sp_time) {
            $user_id = $userObj->id;
            $spuid = $userObj->spuid; //是否已有推荐人
            if (!$spuid && $user_id != $shuid) {
                $userObj->spuid = $shuid; //直推
                $userObj->second_spuid = $spObj->spuid; //间推
                $userObj->save();
            }
        }
        return $this->JsonResponse('');
    }

    //我的邀请
    public function getMyShare(Request $request)
    {
        $user_id = $request->user()->id;
        $page = $request->page ?? 1;
        $limit = $request->limit ?? 10;
        $sql = User::where(['spuid' => $user_id, 'deleted_at' => null]);
        $data = [
            'total' => $sql->count(),
            'total_page' => ceil($sql->count() / $limit),
            'list' => []
        ];
        $listData = $sql->offset(($page - 1) * $limit)->limit($limit)->orderBy('created_at', 'DESC')->get();
        if ($listData->toArray()) {
            foreach ($listData as $item) {
                $data['list'][] = [
                    'name' => $item->name,
                    'avatar' => ($item->avatar ? env('IMAGE_URL') . $item->avatar : ''),
                    'addtime' => date('Y-m-d H:i:s', strtotime($item->created_at))
                ];
            }
        }
        return  $this->JsonResponse($data);
    }

    //我的好友
    public function getMyFriend(Request $request)
    {
        $user_id = $request->user()->id;
        $page = $request->page ?? 1;
        $limit = $request->limit ?? 10;
        $type = $request->type ?? 1; //1: 直推 2：间推
        $where = [];
        if ($type == 1) {
            $where['spuid'] = $user_id;
        } else {
            $where['second_spuid'] = $user_id;
        }
        $sql = User::where(['deleted_at' => null])->where($where); 
        $data = [
            'total' => $sql->count(),
            'total_page' => ceil($sql->count() / $limit),
            'directAmount' => 0,
            'indirectAmount' => 0,
            'list' => []
        ];

        //直推佣金总额 indirect【改成总积分了】
        $directAmount = UserPointChangeRec::where('change_type', 1)
            ->where('point_state', 1)
            ->where('source', 1)
            ->where('user_id', $user_id)
            ->selectRaw('sum(point_amount) as sum_point')
            ->first();
        $data['directAmount'] = (float)($directAmount->sum_point ?? 0);

        //间推佣金总额 indirect
        $indirectAmount = UserPointChangeRec::where('change_type', 1)
            ->where('point_state', 1)
            ->where('source', 2)
            ->where('user_id', $user_id)
            ->selectRaw('sum(point_amount) as sum_point')
            ->first();
        $data['indirectAmount'] = (float)($indirectAmount->sum_point ?? 0);

        $listData = $sql->offset(($page - 1) * $limit)->limit($limit)->orderBy('created_at', 'DESC')->get();
        if ($listData->toArray()) {
            foreach ($listData as $item) {
                $divide_price = UserPointChangeRec::where('change_type', 1)//增加
                    ->where('point_state', 1)//已完成
                    ->where('source', $type)//直推or间推
                    ->whereHas('order', function($query) use ($item) {
                        $query->where('user_id', $item->id)
                            ->where('pay_type', 1)
                            ->where('pay_status', 1)
                            ->where('order_status', '!=', 7);
                    })
                    ->sum('point_amount');

                $data['list'][] = [
                    'name' => $item->name,
                    'divide_price' => (float)$divide_price,
                    'avatar' => ($item->avatar ? env('IMAGE_URL') . $item->avatar : env('IMAGE_URL') . '/wximg/my.png'),
                    'addtime' => date('Y-m-d H:i:s', strtotime($item->created_at))
                ];
            }
        }

        return  $this->JsonResponse($data);
    }

    //绑定直购码
    public function bindBuycode(Request $request)
    {
        $userObj = $request->user();
        if ($userObj->buycode) {
            return  $this->JsonResponse('已经绑定过直购码'); //直接返回成功
        }

        $code = $request->code ?? '';

        $merObj = Merchant::where("buycode", $code)->first();
        if (!$merObj) {
            return $this->JsonResponse('', '参数有误，没有该商户', 500);
        }
        DB::beginTransaction();
        try {
            $userObj->buycode = $code;
            $userObj->merchant_id = $merObj->id;
            $userObj->save();
            DB::commit();
        } catch (\Exception $exception) {
            Log::add('绑定直购码失败', $exception->getMessage());
            DB::rollBack();
            return $this->JsonResponse('', '绑定直购码失败', 201);
        }

        return  $this->JsonResponse('');
    }



    //获取用户积分列表
    /**
     * 获取用户积分明细列表
     * 
     * @param Request $request HTTP请求对象
     * @return \Illuminate\Http\JsonResponse JSON响应
     * 
     * 返回数据结构:
     * {
     *     "total": 总记录数,
     *     "list": [
     *         {
     *             "id": 记录ID,
     *             "point_amount": 积分变动金额,
     *             "change_type": 变动类型(1-增加,2-减少),
     *             "point_state": 积分状态(1-可用,2-解冻中,3-冻结中),
     *             "source": "来源中文描述",
     *             "created_at": 创建时间
     *         }
     *     ]
     * }
     * 
     * 使用示例:
     * GET /api/user/point-list
     * 
     * 注意事项:
     * 1. 默认返回最近30条记录
     * 2. 支持分页参数page和limit
     * 3. 按创建时间倒序排列
     */
    public function getUserPointList(Request $request)
    {
        $user = $request->user();
        $page = $request->page ?? 1;
        $limit = $request->limit ?? 30;

        $query = UserPointChangeRec::where('user_id', $user->id)
            ->orderBy('created_at', 'DESC');

        $total = $query->count();
        $list = $query->offset(($page - 1) * $limit)
            ->limit($limit)
            ->get([
                'id',
                'point_amount',
                'change_type',
                'point_state',
                'source',
                'created_at'
            ])
            ->map(function ($item) {
                $item->source = UserPointChangeRec::source[$item->source] ?? '未知来源';
                return $item;
            });

        return $this->JsonResponse([
            'total' => $total,
            'list' => $list
        ]);
    }
}
