<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Models\OrderInfo as OrderInfoModel;
use App\Models\OrderDivideRecord;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SystemController extends BaseController
{
    //远程开启、暂停登录
    public function update(Request $request)
    {
        $status = $request->type ? (int)$request->type : 1;
        $exist = DB::table('admin_status')->where("slug", 'login')->first();
        if (!$exist) {
            return $this->JsonResponse('', '配置信息不存在', 201);
        }

        $updated_at = date("Y-m-d H:i:s");
        DB::table('admin_status')->where("slug", 'login')->update(['status' => $status, 'updated_at' => $updated_at]);

        return $this->JsonResponse('');
    }

    //定时任务--待领取状态下七天未领取，自动到待评价状态
    public function autoChangeReceiveStatus()
    {
        $chunkSize = 50; // 每次处理的订单数量
        $orders = OrderInfoModel::where(["order_status" => 2])->whereNull('verification_at')->whereNotNull('verifi_code_at')->orderBy('id')->take($chunkSize);
        while ($orders->count() > 0) {
            $orders->chunk($chunkSize, function ($batch) {
                foreach ($batch as $order) {
                    $nowtime = time();
                    if ($order->verifi_code_at) {
                        $wait_time = strtotime($order->verifi_code_at);
                        $diff_time = $nowtime - $wait_time;
                        $d = $diff_time / 86400;
                        if ($d >= 7) {
                            $order->order_status = 3;
                            $order->save();
                        }
                    }
                }
            });

            // 移动游标到下一批
            $orders->skip($chunkSize);
            $orders = $orders->getQuery();
            sleep(2);
        }

        return '--ok--';
    }
}
