<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Models\Carousel;
use App\Models\User;
use App\Models\HfPayconfirm;
use App\Models\OrderDivideRecord;
use Illuminate\Http\Request;
use NwVVVS\AdapayCore\AdaPay\Payment;
use Illuminate\Support\Facades\DB;
use App\Models\Adapay;
use App\Models\OrderInfo;


class OrderDivideRecordController extends BaseController
{
    public function getList(Request $request)
    {
        $type = $request->type ?? 0;
        $page = $request->page ?? 1;
        $limit = $request->limit ?? 10;
        if (!in_array($type, [3,5])) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        $userObj = $request->user();
        $um_id = ($type == 3) ? $userObj->merchant_id  : $userObj->member_id;
        $sql = OrderDivideRecord::where(['um_id' => $um_id, 'sh_type' => $type, 'is_div' => 1, 'deleted_at' => null]);
        $total = $sql->count();
        $data = [
            'total' => $total,
            'total_page' => ceil($total / $limit),
            'list' => []
        ];

        
        //查询冻结中未分佣订单的预计分账金额,在第一页追加
        //判断是员工还是商家
        $add_sql='';
        if ($type == 3&&$page==1) {
            $add_sql="SELECT 
                            log.id,
                            log.goods_id,
                            log.order_id,
                            log.merchant_id,
                            log.goods_price,
                            lg.merchant_commission,
                            sau.employee_commission,
                                log.created_at,
                            ROUND((log.goods_price * lg.merchant_commission * 1.0) / 100, 2) AS merchant_amount,
                            ROUND((log.goods_price * lg.merchant_commission * sau.employee_commission) / 10000, 2) AS employee_amount,
                            -- 使用 COALESCE 函数处理 NULL 值
                            COALESCE(
                                ROUND(((log.goods_price * lg.merchant_commission * 1.0) / 100) - ((log.goods_price * lg.merchant_commission * sau.employee_commission) / 10000), 2),
                                ROUND((log.goods_price * lg.merchant_commission * 1.0) / 100, 2)
                            ) AS divide_price
                        FROM 
                            li_order_goods log 
                        LEFT JOIN 
                            li_order_info loi ON log.order_id = loi.id  
                        LEFT JOIN 
                            li_goods lg ON log.goods_id = lg.id 
                        LEFT JOIN 
                            store_employee_user_rec seur ON seur.user_id = loi.user_id 
                        LEFT JOIN 
                            store_admin_users sau ON sau.id = seur.employee_id  
                        WHERE 
                            loi.is_div = 0 and loi.pay_type=1 and loi.deleted_at is null
		                    AND loi.order_status in (3,4)
                            AND loi.merchant_id = {$um_id}
                        order by log.id desc ";
        } else if($type == 5&&$page==1) {
            $add_sql="SELECT 
                            log.id,
                            log.goods_id,
                            log.order_id,
                            log.merchant_id,
                            log.goods_price,
                            lg.merchant_commission,
                            sau.employee_commission,
                                log.created_at,
                            ROUND((log.goods_price * lg.merchant_commission * 1.0) / 100, 2) AS merchant_amount,
                            ROUND((log.goods_price * lg.merchant_commission * sau.employee_commission) / 10000, 2) AS divide_price,
                            -- 使用 COALESCE 函数处理 NULL 值
                            COALESCE(
                                ROUND(((log.goods_price * lg.merchant_commission * 1.0) / 100) - ((log.goods_price * lg.merchant_commission * sau.employee_commission) / 10000), 2),
                                ROUND((log.goods_price * lg.merchant_commission * 1.0) / 100, 2)
                            ) AS merchant_employee_amount
                        FROM 
                            li_order_goods log 
                        LEFT JOIN 
                            li_order_info loi ON log.order_id = loi.id  
                        LEFT JOIN 
                            li_goods lg ON log.goods_id = lg.id 
                        LEFT JOIN 
                            store_employee_user_rec seur ON seur.user_id = loi.user_id 
                        LEFT JOIN 
                            store_admin_users sau ON sau.id = seur.employee_id  
                        WHERE 
                            loi.is_div = 0 and loi.pay_type=1 and loi.deleted_at is null
		                    AND loi.order_status in (3,4)
                            AND sau.member_id ='{$um_id}'
                        order by log.id desc ";
        }

        if ($add_sql) {
            $addData = DB::select($add_sql);
            if ($addData) {
                foreach ($addData as $kk => $vv) {
                    $data['list'][] = [
                        'title' =>'用户取货佣金-冻结中',
                        'created_at' => date("Y-m-d H:i:s", strtotime($vv->created_at)),
                        'divide_price' => $vv->divide_price
                    ];
                }
            }
        }



        //已分账记录
        $listData = $sql->offset(($page - 1) * $limit)->limit($limit)->orderBy('created_at', 'DESC')->get();
        if ($listData->toArray()) {
            foreach ($listData as $kk => $vv) {
                $data['list'][] = [
                    'title' =>'用户取货佣金',
                    'created_at' => date("Y-m-d H:i:s", strtotime($vv->created_at)),
                    'divide_price' => $vv->divide_price
                ];
            }
        }

        



        return  $this->JsonResponse($data);
    }

    //手动分账【开发手动调接口修正数据】
    public function manualDivide(Request $request)
    {
        $payment_confirm = new \NwVVVS\AdapaySdk\PaymentConfirm(); //支付确认

        $member_id = $request->member_id ?? 0; //汇付会员id
        $user_id = $request->user_id ?? 0; //用户
        $amount = $request->amount; //分账金额·
        $payment_id = $request->payment_id; //支付记录表中的payment_id，每笔支付订单可以分账多次
        if (!$amount || !$payment_id || !$user_id) {
            return $this->JsonResponse('', '参数 amount、payment_id 不能为空', 201);
        }

        //参数介绍member_id：汇付会员id，amount：分账金额，fee_flag：是否内扣手续费
        $div_members = ['member_id' => $member_id, 'amount' => sprintf("%.2f", $amount), 'fee_flag' => 'Y'];
        $confirm_amt = sprintf("%.2f", $amount);  // 确保金额格式化为两位小数

        # 支付确认参数设置
        $payment_params = array(
            "payment_id" => $payment_id,
            "order_no" => 'payconfirm_' . date("YmdHis") . rand(100000, 999999),
            "confirm_amt" => $confirm_amt,  // 使用格式化后的金额
            "description" => "",
            "div_members" => $div_members,
        );
        // $payment_params['div_members'] = $div_members;
        // $payment_params['confirm_amt'] = $confirm_amt;

        //Log::add('manualDivide手动分账' , $payment_params);

        # 发起支付确认创建
        $payment_confirm->create($payment_params);

        # 对支付确认创建结果进行处理
        $logData = [
            'request_params' => $payment_params,
            'response' => $payment_confirm->result
        ];

        if ($payment_confirm->isError()) {
            //失败处理
            Log::add('manualDivide手动分账', json_encode($logData, JSON_UNESCAPED_UNICODE));
            return $this->JsonResponse($logData, '支付确认失败', 201);
        } else {
            //成功处理
            $result = $payment_confirm->result;
            Log::add('manualDivide手动分账', json_encode($logData, JSON_UNESCAPED_UNICODE));

            if ($result['status'] == 'succeeded') {
                //写入支付确认信息
                $hfResult = (new HfPayconfirm())->add($payment_params, $result['fee_amt']);
                $logData['hf_result'] = $hfResult;

                //新增分佣记录
                OrderDivideRecord::addRecord(
                    og_id: '', // og_id (这里没有商品ID信息，可以传空字符串)
                    order_id: $payment_id, // order_id (使用payment_id作为订单ID)
                    goods_amount: $amount, // goods_amount (使用分账金额作为商品金额)
                    divide_price: $amount, // divide_price (使用分账金额)
                    commission: '', // commission (比例信息，这里没有可以传空)
                    um_id: $user_id, // um_id (直推、间推、商家的user_id)
                    buyer_id: $user_id, // buyer_id (这里没有买家ID，就是用户id)
                    sh_type: 4, // sh_type (3表示用户取货佣金)
                    isExistAccount: 1, // isExistAccount (假设已实名)
                    payconfirm_no: $payment_params['order_no'] // payconfirm_no (使用生成的订单号)
                );

                return $this->JsonResponse($logData);
            } else {
                return $this->JsonResponse($logData, '支付确认处理中', 202);
            }
        }
        return  $this->JsonResponse([]);
    }



    //后面改成消息队列，先单线程运行，快速开发
    //轮训更新订单冻结状态，将冻结完成的订单进行分账
    public function updateOrderStatusToDiv(Request $request)
    {
        //查询完成冻结的订单,分账
        $orderList = DB::select('SELECT id,order_sn,user_id,order_amount,freeze_end_date
                            FROM li_order_info
                            WHERE deleted_at IS NULL
                            AND pay_status = 1
                            AND is_div = 0
                            AND order_amount > 0
                            AND freeze_end_date is not null 
                            AND freeze_end_date < NOW()
                            AND order_status IN (3, 4);
                            ');

        if ($orderList) {
            foreach ($orderList as $kk => $order) {
                $orderObj = OrderInfo::find($order->id);
  
                if (!$orderObj) {
                    Log::add('updateOrderStatusToDiv订单不存在:'.$order->id, json_encode($orderObj, JSON_UNESCAPED_UNICODE));
                    continue;
                }

                if (Adapay::handlePaymentConfirmAndDivide($orderObj->order_sn, $orderObj->id)) {
                    $orderObj->is_div = 1;
                    $orderObj->save();
                } else {
                    //分账失败，记录日志
                    Log::add('updateOrderStatusToDiv分账失败', json_encode($order, JSON_UNESCAPED_UNICODE));
                }
            }
        }

        return  $this->JsonResponse([]);
    }


    
    /**
     * 轮训用户积分解冻中积分，改成已解冻，积分进入用户账户
     * @return bool 返回操作结果
     * 
     * 功能说明：
     * 1. 查询所有解冻中(状态为2)的积分记录
     * 2. 检查解冻结束日期是否已到
     * 3. 将符合条件的记录状态更新为已完成(1)
     * 4. 将积分转入用户账户
     * 
     * 使用示例：
     * UserPointChangeRec::pointUnfreezeEnd();
     * 
     * 注意事项：
     * 1. 仅处理状态为解冻中(2)的积分记录
     * 2. 仅处理解冻结束日期小于当前时间的记录
     * 3. 操作在事务中进行，保证数据一致性
     */
    public static function pointUnfreezeEnd(Request $request)
    {
        DB::beginTransaction();
        try {
            // 查询解冻中积分
            $records = DB::table('user_point_change_rec')
                ->where([
                    'point_state' => 2, // 解冻中
                    'change_type' => 1   // 增加积分
                ])
                ->where('freeze_end_date', '<=', date('Y-m-d H:i:s'))
                ->get();

            if ($records->isEmpty()) {
                Log::add('point_unfreeze_end', [
                    'msg' => '没有找到可完成的解冻积分记录'
                ]);
                return true;
            }

            
            Log::add('point_unfreeze_end', [
                'count' => count($records),
                'msg' => '成功完成积分解冻'
            ]);

            foreach ($records as $record) {
                // 更新积分记录状态为已完成
                DB::table('user_point_change_rec')
                    ->where('id', $record->id)
                    ->update([
                        'point_state' => 1, // 已完成
                    ]);

                // 将积分转入用户账户
                $user = User::find($record->user_id);
                $user->balance += $record->point_amount;
                $user->total_revenue += $record->point_amount;
                $user->save();
            }

            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            Log::add('point_unfreeze_end_error', [
                'error' => $e->getMessage()
            ]);
            return false;
        }
    }
    




}
