<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Models\Adapay;
use App\Models\UserAddress;
use App\Models\Store;
use App\Models\Good as GoodModel;
use App\Models\User as UserModel;
use App\Models\PaymentRecord;
use App\Models\GoodSku;
use App\Models\OrderGoods;
use App\Models\OrderInfo as OrderInfoModel;
use App\Models\MerchantGoodSku;
use Dcat\Admin\Grid\Displayers\Orderable;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use League\CommonMark\Node\Query\OrExpr;
use App\Handlers\MpAaccessToken;
use DateTime;
use DateTimeZone;
use Exception;
use App\Models\UserPointChangeRec;

class OrderController extends BaseController
{

    //立即购买-确认订单【提供前端一些订单信息】
    public function CheckoutBuyOrder(Request $request)
    {
        $userObj = $request->user();
        $merchant_id = $userObj->merchant_id ?? 0;
        $goods_id = $request->goods_id;
        $num = $request->num ?? 1;
        $attr_name = $request->attr_name ?? '';
        $goodsObj = GoodModel::find($goods_id);
        if (!$goodsObj) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        $attr_val = '';
        $goods_price = 0;
        if ($attr_name) {
            $attrArr = explode(",", $attr_name);
            utf8_array_asort($attrArr);
            $attrStr = join("、", $attrArr);
            $attr_sn = md5($attrStr);
            $arrObj = GoodSku::where('goods_id', $goods_id)->where('attr_sn', $attr_sn)->first();
            $attr_val = $arrObj ? $arrObj->attr_val : '';
            $attr_id = $arrObj ? $arrObj->id : 0;
            $goods_price = ($arrObj && $goodsObj->goods_type && $merchant_id) ? $arrObj->cg_price : $arrObj->market_price;
        }


        $data = [];
        $data['goods_id'] = $goods_id;
        $data['goods_name'] = $goodsObj->goods_name;
        $data['goods_img'] = $goodsObj->cover_img ? togetherFilePath($goodsObj->cover_img) : '';
        $data['num'] = $num;
        $data['attr_id'] = $attr_id;
        $data['goods_price'] = $goods_price;
        $data['attr_name'] = $attr_val;

        return $this->JsonResponse($data);
    }

    //创建订单[单商品]
    public function CreateBuyOrder(Request $request)
    {
        $orderObj = new OrderInfoModel();
        $userObj = $request->user();
        $user_id = $userObj->id;
        $merchant_id = (int)$userObj->merchant_id; //绑定的商户ID
        $spuid = $userObj->spuid; //直推
        $goods_id = $request->goods_id;
        $num = $request->num ?? 1;
        $attr_id = $request->attr_id ?? 0;
        $delivery_type = $request->delivery_type; // 收货方式 1:代收点 2：送货上门
        $store_id = $request->store_id ?? 0; //代收点 门店ID
        //----收货地址----
        $address = $request->address ?? ''; //详情地址
        $area = $request->area ?? '';
        $phone = $request->phone ? $request->phone : $userObj->phone;
        $consignee = $request->consignee ?? '';
        //$address_id = $request->address_id ?? 0; //地址ID

        $buycode = $request->buycode; //直购码

        $goodsObj = GoodModel::find($goods_id);
        if (!$goodsObj) {
            return $this->JsonResponse('', '商品参数错误', 201);
        }
        // $userAddress = '';
        // if ($address_id) {
        //     $userAddress = UserAddress::where("id", $address_id)->first();
        // }

        $order_sn = $this->getOrderSn();
        DB::beginTransaction();
        try {
            $total_price = 0;
            $orderGoods = [];
            //商品信息
            $goodObj = GoodModel::find($goods_id);
            $good_price = 0; //商品单价
            //判断是否有规格
            $attr_val = '';
            if ($attr_id) {
                $arrObj = GoodSku::where(['id' => $attr_id, 'goods_id' => $goods_id])->first();
                if (!$arrObj) {
                    return $this->JsonResponse('', 'sku参数错误', 201);
                } else {
                    if ($arrObj->stock < $num) {
                        return $this->JsonResponse('', '该商品库存不足', 500);
                    }
                }
                $attr_val = $arrObj ? $arrObj->attr_val : '';
                $good_price = ($arrObj && $goodsObj->goods_type && $merchant_id && $buycode) ? $arrObj->cg_price : $arrObj->market_price;
            }
            //商品总价
            $total_price = ($good_price * $num);


            $order_amount = $total_price; //订单金额
            $order_status = 0;
            $pay_status = 0;


            $tmp = [];
            $tmp['goods_id'] = $goods_id;
            $tmp['goods_number'] = $num;
            $tmp['goods_price'] = $good_price;
            $tmp['goods_attr'] = $attr_val;
            $tmp['attr_id'] = $attr_id;
            $tmp['goods_name'] = $goodObj->goods_name;
            $tmp['goods_img'] = $goodObj->cover_img;
            $tmp['merchant_id'] = $merchant_id;
            $tmp['created_at'] = date("Y-m-d H:i:s");
            array_push($orderGoods, $tmp);
            //订单信息
            $orderObj->order_sn = $order_sn;
            $orderObj->user_id = $user_id;
            $orderObj->area = $area;
            $orderObj->address = $address;
            $orderObj->consignee = $consignee;
            $orderObj->mobile = $phone;
            $orderObj->goods_amount = $total_price;
            $orderObj->order_amount = $order_amount;
            $orderObj->order_status = $order_status;
            $orderObj->pay_status = $pay_status;
            $orderObj->goods_sn = $goodObj->goods_sn;
            $orderObj->delivery_type = $delivery_type;
            $orderObj->merchant_id = $merchant_id;
            $orderObj->store_id = $store_id;
            $orderObj->is_commission = ($spuid || $merchant_id) ? 1 : 0;
            if ($orderObj->save()) {
                $order_id = $orderObj->id;
                foreach ($orderGoods as $key => $item) {
                    $orderGoods[$key]['order_id'] = $order_id;
                }
                DB::table("li_order_goods")->insert($orderGoods);
            }
            DB::commit();
            //15分钟取消订单
            //$this->dispatch(new CancelOrder($orderObj, 900));
            return $this->JsonResponse(['order_id' => $orderObj->id, 'order_amount' => $order_amount]);
        } catch (\Exception $exception) {
            Log::add('创建预支付订单失败', $exception->getMessage());
            DB::rollBack();
            return $this->JsonResponse('', '创建预支付订单失败', 201);
        }
    }

    //创建订单[购物车]
    public function CreateOrder(Request $request)
    {
        $orderObj = new OrderInfoModel();
        $userObj = $request->user();
        $user_id = $userObj->id;
        $merchant_id = $userObj->merchant_id;
        $spuid = $userObj->spuid; //直推
        $catKey = $request->catKey ?? ''; //购物车KeyID拼接 5_1,6_2
        $delivery_type = $request->delivery_type; // 收货方式 1:代收点 2：送货上门
        $store_id = $request->store_id ?? 0; //代收点 门店ID
        //----收货地址----
        $address = $request->address ?? ''; //详情地址
        $area = $request->area ?? '';
        $phone = $request->phone ? $request->phone : $userObj->phone;
        $consignee = $request->consignee ?? '';

        $buycode = $request->buycode; //直购码

        if (!$catKey) {
            return $this->JsonResponse('', '参数错误', 201);
        }

        $shoppingCart = $userObj->shopping_cart ? json_decode($userObj->shopping_cart, true) : [];
        if (empty($shoppingCart)) {
            return $this->JsonResponse('', '购物车无资源', 500);
        }

        $order_sn = $this->getOrderSn();
        DB::beginTransaction();
        try {
            $total_price = 0;
            $idsArr = explode(",", $catKey);
            $orderGoods = [];
            $goods_name = '';
            foreach ($idsArr as $key) {
                $cartRow = isset($shoppingCart[$key]) ? $shoppingCart[$key] : [];
                if (!$cartRow) {
                    continue;
                }
                //商品信息
                $goods_id = $cartRow['goods_id'];
                $attr_id = $cartRow['attr_id'];
                $goodsObj = GoodModel::find($goods_id);
                $skuObj = GoodSku::find($attr_id);
                if (!$goodsObj || !$skuObj) {
                    unset($shoppingCart[$key]);
                    continue;
                } else {
                    if ($skuObj->stock < $cartRow['num']) {
                        return $this->JsonResponse('', '该商品库存不足！', 500);
                    }
                }
                $goods_price = ($merchant_id && $goodsObj->goods_type && $buycode) ? $skuObj->cg_price : $skuObj->market_price;
                $goods_img = isset($goodsObj->cover_img) ? $goodsObj->cover_img  : '';
                $goods_name .= $goodsObj->goods_name . "、";

                $tmp = [];
                $tmp['goods_id'] = $goods_id;
                $tmp['goods_number'] = $cartRow['num'];
                $tmp['goods_price'] = $goods_price;
                $tmp['goods_attr'] = $cartRow['attr_txt'];
                $tmp['attr_id'] =  $attr_id;
                $tmp['goods_name'] = $goodsObj->goods_name;
                $tmp['goods_img'] = $goods_img;
                $tmp['merchant_id'] = $merchant_id;
                $tmp['created_at'] = date("Y-m-d H:i:s");
                array_push($orderGoods, $tmp);
                //总价
                $total_price += ((float)$goods_price * (int)$cartRow['num']);
                //删除购物车商品
                unset($shoppingCart[$key]);
            }
            if ($total_price == 0) {
                return $this->JsonResponse('', '参数错误', 201);
            }

            $order_amount = $total_price; //订单金额
            $order_status = 0;
            $pay_status = 0;


            $orderObj->order_sn = $order_sn;
            $orderObj->user_id = $user_id;
            $orderObj->address = $address;
            $orderObj->area = $area;
            $orderObj->consignee = $consignee;
            $orderObj->mobile = $phone;
            $orderObj->goods_amount = $total_price;
            $orderObj->order_amount = $order_amount;
            $orderObj->order_status = $order_status;
            $orderObj->pay_status = $pay_status;
            $orderObj->delivery_type = $delivery_type;
            $orderObj->merchant_id = $merchant_id;
            $orderObj->store_id = $store_id;
            $orderObj->is_commission = ($spuid || $merchant_id) ? 1 : 0;

            if ($orderObj->save()) {
                $order_id = $orderObj->id;
                foreach ($orderGoods as $key => $item) {
                    $orderGoods[$key]['order_id'] = $order_id;
                }
                DB::table("li_order_goods")->insert($orderGoods);
            } else {
                return $this->JsonResponse('', '创建购物车订单失败', 201);
            }
            $userObj->shopping_cart = empty($shoppingCart) ? null : json_encode($shoppingCart, JSON_UNESCAPED_UNICODE);
            $userObj->save();
            DB::commit();

            return $this->JsonResponse(['order_id' => $orderObj->id, 'order_amount' => $order_amount]);
        } catch (\Exception $exception) {
            Log::add('创建购物车订单失败', $exception->getMessage());
            DB::rollBack();
            return $this->JsonResponse('', '创建购物车订单失败', 201);
        }
    }

    private function getOrderSn()
    {
        $order_sn = '';
        $flag = 0;
        do {
            //'20231229875256'; 
            $order_sn = date('Ymd') . mt_rand(1000, 9999) . substr(implode("", array_map('ord', str_split(substr(uniqid(), 7, 13), 1))), 0, 8);
            $rowObj = OrderInfoModel::where('order_sn', $order_sn)->first();
            $flag = $rowObj ? 0 :  1;
        } while ($flag < 1);
        return $order_sn;
    }

    //订单【支付】-微信
    public function pay(Request $request)
    {
        $order_id = $request->order_id ?? 0;
        $userObj = $request->user();
        $openid = $userObj->openid;

        DB::beginTransaction();
        try {
            // 订单不存在直接返回错误
            $order = OrderInfoModel::find($order_id);
            if (!$order) {
                return $this->JsonResponse('', '订单不存在', 404);
            }
            // 订单状态必须为待支付(0)
            if ($order->order_status != 0) {
                return $this->JsonResponse('', '请勿重复支付！', 500);
            }

            $pay_type = $request->pay_type; //支付方式 1：微信 2：积分 3：混合
            if ($order->pay_cs > 0) {

                //第二次支付不用选择，从订单查询支付方式，2
                $pay_type = $order->pay_type;
                if ($pay_type == '3') { //混合支付后的二次支付，不用在扣除余额了
                    $pay_type = 4;
                }
            } else {

                if (!in_array($pay_type, [1, 2, 3])) {
                    return $this->JsonResponse('', '请选择支付方式', 500);
                }
            }

            if ($order->pay_cs < 20) { //微信每次支付需要重新生成订单号
                $order_record = $order->order_record ?? $order->order_sn;
                $order->order_sn = $this->getOrderSn();
                $order->order_record = $order_record . "|" . $order->order_sn;
                $order->save();
            } else {
                return $this->JsonResponse('', '支付次数达到上限！', 500);
            }

            $point_amount = 0; //积分抵扣金额
            $order_amount = $order->order_amount; //订单金额
            //判断支付方式
            if ($pay_type == 1) {
                $order->pay_type = $pay_type; //支付方式
                $order->point_amount = $point_amount; //积分抵扣金额
                $order->pay_cs += 1;
            } else if ($pay_type == 2) {
                if ($userObj->balance < $order_amount) {
                    return $this->JsonResponse('', '积分不足！', 500);
                }

                //扣除积分
                if (!UserPointChangeRec::pointChangeRecord($userObj->id, $order_amount, 0, 3, 1, $order_id)) {
                    return $this->JsonResponse('', '网络异常，积分抵扣失败！002', 500);
                }

                //积分支付
                $order->pay_type = $pay_type; //支付方式
                $order->point_amount = $order_amount; //积分抵扣金额
                $order->pay_cs += 1;
                $order->order_amount = 0; //订单金额0
                $order->pay_status = 1; //支付状态
                $order->order_status = 1; //订单状态

                //更新商品库存
                $Adapay = new Adapay();
                $Adapay->updateGoodsStock($order);

                $order->save();
                DB::commit();

                return $this->JsonResponse('', '积分支付成功！', 200);
            } else if ($pay_type == 3) {
                if ($userObj->balance >= $order_amount) {
                    return $this->JsonResponse('', '积分充足，可选择积分支付！', 500);
                }

                //判断是否有足够的积分支付
                if ($userObj->balance <= 0) {
                    return $this->JsonResponse('', '积分不足！', 500);
                }

                //扣除积分
                if (!UserPointChangeRec::pointChangeRecord($userObj->id, $userObj->balance, 0, 3, 1, $order_id)) {
                    return $this->JsonResponse('', '网络异常，积分抵扣失败！003', 500);
                }
                $order_amount = $order_amount - $userObj->balance;
                $order->pay_type = $pay_type; //支付方式
                $order->point_amount = $userObj->balance; //积分抵扣金额
                $order->order_amount = $order_amount;
                $order->pay_cs += 1;
                $order->save();
            } else {
                //微信或者混合支付第二次进来支付，不用做任何处理
                Log::add('--第n次支付--', ['order_id' => $order_id, 'order_sn' => $order->order_sn]);
                $order->pay_cs += 1;
            }

            $res = '';

            $orderGoodsObj = OrderGoods::where("order_id", $order_id)->first();
            $order_title = $orderGoodsObj ? $orderGoodsObj->goods_name : '';
            Log::add('--支付订单号ID--', ['order_id' => $order_id, 'order_sn' => $order->order_sn]);
            $res = (new Adapay())->pay($order_title, $order->order_sn, $order_amount, $openid);
            $order->save();

            DB::commit();
            return $this->JsonResponse($res);
        } catch (\Exception $exception) {
            Log::add('拉起微信支付失败', $exception->getMessage());
            return $this->JsonResponse('', $exception->getMessage(), 500);
        }
    }

    //付款回调
    public function payNotify(Request $request)
    {
        Log::add('--支付回调结果--', $_POST);
        $fields = $_POST ?? [];
        //$result = file_get_contents('php://input');
        return $this->JsonResponse((new Adapay())->payNotify($fields));
    }


    // 已完成：用户点击确认收货或发货后3天，自动变更为已完成状态
    // 售后：已完成状态下48小时内展示申请售后按钮，可申请售后，如超过48小时，则不展示申请售后按钮
    public function orderList(Request $request)
    {
        $status = $request->order_status ?? -1;
        $page = $request->page ?? 1;
        $limit = $request->limit ?? 10;


        $user_id = $request->user_id;
        //如果传入user_id 则查询该用户的订单，验证当前用户是否核销员
        if (!$user_id) {
            $user_id = $request->user()->id;
        }

        $sql = OrderInfoModel::where(['user_id' => $user_id, 'deleted_at' => null]);

        if ($status >= 0) {
            $sql = $sql->where(['order_status' => $status]);
        }
        $total = $sql->count();
        $data = [
            'total' => $total,
            'total_page' => ceil($total / $limit),
            'list' => []
        ];
        $listData = $sql->offset(($page - 1) * $limit)->limit($limit)->orderBy('created_at', 'DESC')->get();
        if ($listData->toArray()) {
            foreach ($listData as $item) {
                //订单商品
                $order_goods = [];
                $ogoods = OrderGoods::where(["order_id" => $item->id])->limit(1)->get();
                foreach ($ogoods as $key => $valObj) {
                    $tmp = [];
                    $tmp['og_id'] = $valObj->id;
                    $tmp['goods_id'] = $valObj->goods_id;
                    $tmp['goods_name'] = $valObj->goods_name;
                    $tmp['goods_number'] = $valObj->goods_number;
                    $tmp['goods_attr'] = $valObj->goods_attr;
                    $tmp['goods_price'] = $valObj->goods_price;
                    $tmp['goods_img'] = $valObj->goods_img ? togetherFilePath($valObj->goods_img) : '';
                    $tmp['is_comment'] = $valObj->is_comment;
                    array_push($order_goods, $tmp);
                }
                $data['list'][] = [
                    'order_id' => $item->id,
                    'order_sn' => $item->order_sn,
                    'order_status' => $item->order_status,
                    'status_txt' => OrderInfoModel::STATUS_OPTIONS[$item->order_status],
                    //'is_apply' => $is_apply,
                    //'service_status' => $item->service_status,
                    'order_amount' => $item->order_amount,
                    'verification_code' => $item->verification_code ?? '',
                    'created_at' => date("Y-m-d H:i", strtotime($item->created_at)),
                    'order_goods' => $order_goods
                ];
            }
        }
        return $this->JsonResponse($data);
    }

    //取消订单
    public function canceOrder(Request $request)
    {
        $order_id = $request->order_id ?? null;
        $model = OrderInfoModel::find($order_id);
        if (!$model) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        if ($model->user_id != $request->user()->id) {
            return $this->JsonResponse('', '非本人订单', 201);
        }

        //前端只能取消待支付、待发货订单
        if (!in_array($model->order_status, [0, 1])) {
            return $this->JsonResponse('', '不满足取消条件' . $model->order_status, 500);
        }

        $this->canceOrderFunc($model);
        return  $this->JsonResponse('');
    }

    //取消订单-纯方法
    public static function canceOrderFunc($order)
    {
        DB::beginTransaction();
        try {

            //未分账才可以退款
            if ($order->is_div == 1) {
                return (new self())->JsonResponse('', '订单已完成分账，无法取消！', 500);
            }

            $Adapay = new Adapay();

            //未支付订单--改状态直接退出
            if ($order->order_status == 0) {
                $order->order_status = 7;
                $order->save();

                DB::commit();
                //未支付直接取消
                Log::info($order->id);

                //如果组合支付返还积分
                if ($order->pay_type == 3) {
                    //返还用户积分
                    UserPointChangeRec::pointChangeRecord($order->user_id, $order->point_amount, 1, 4, 1, $order->id);
                }

                return (new self())->JsonResponse('');
            }


            //判断状态是否正常；订单状态 0:待付款 1:待到货 2:待领取 3: 待评价 4:已完成  7:已取消 8:已退款
            if (!in_array($order->order_status, [1, 2, 3, 4])) {
                return (new self())->JsonResponse('', '订单状态不可退款！', 500);
            }


            $Adapay->updateGoodsStock($order, true);

            //判断支付方式现金还是积分， 1：微信，2：积分，3：微信+积分
            //判断是否现金支付，查询是否需要收回冻结中的积分
            if ($order->pay_type == 1 || $order->pay_type == 3) {

                //未分账订单，退款
                if ($order->order_amount > 0) {
                    $order_sn = $order->order_sn;
                    $refund_no = "R" . date("YmdHis") . rand(100000, 999999); //退单号
                    $result = $Adapay->refund($order_sn, $refund_no);
                    Log::add('refund_result', $result);
                }

                $order->order_status = 8; //已退款
                $order->save();

                // 先获取结果集再操作，通过这笔订单增加的积分，并且状态为冻结中的记录
                $userPointChangeRecs = UserPointChangeRec::where('order_id', $order->id)
                    ->where('point_state', '!=', 1)
                    ->where('change_type', 1)
                    ->get();

                //后期可以把这些记录存入数据库，方便后续操作
                Log::Add('canceOrderFunc', '冻结积分删除记录：' . json_encode($userPointChangeRecs->toArray()));

                // 批量删除冻结中的积分
                UserPointChangeRec::where('order_id', $order->id)
                    ->where('point_state', '!=', 1)
                    ->where('change_type', 1)
                    ->delete();


                //查询是否需要退用户积分
                if ($order->point_amount > 0) {
                    //新增积分
                    if (!UserPointChangeRec::pointChangeRecord($order->user_id, $order->point_amount, 1, 4, 1, $order->id)) {
                        return (new self())->JsonResponse('', '网络异常，积分返还失败！003', 500);
                    }
                }
            } else {

                //查询是否需要退用户积分
                if ($order->point_amount > 0) {
                    //新增积分
                    if (!UserPointChangeRec::pointChangeRecord($order->user_id, $order->point_amount, 1, 4, 1, $order->id)) {
                        return (new self())->JsonResponse('', '网络异常，积分返还失败！004', 500);
                    }
                }
            }

            $order->order_status = 8;
            $order->save();

            DB::commit();
        } catch (\Exception $exception) {
            DB::rollBack();
            Log::add('取消订单失败', $exception->getMessage());
            return (new self())->JsonResponse('', '取消订单失败', 201);
        }
        return (new self())->JsonResponse('成功');
    }


    public function delOrder(Request $request)
    {
        $order_id = $request->order_id ?? null;
        $model = OrderInfoModel::find($order_id);
        if (!$model) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        if ($model->user_id != $request->user()->id) {
            return $this->JsonResponse('', '非本人订单', 201);
        }
        $model->delete();

        return  $this->JsonResponse('');
    }

    //确认收货（订单完成）
    // public function completeOrder(Request $request)
    // {
    //     $order_id = $request->order_id ?? null;
    //     if (!$order_id) {
    //         return $this->JsonResponse('', '参数错误', 201);
    //     }

    //     $model =  OrderInfoModel::find($order_id);
    //     if ($model->user_id != $request->user()->id) {
    //         return $this->JsonResponse('', '非本人订单', 201);
    //     }
    //     $model->shipping_status = 2;
    //     $model->order_status = 2;
    //     $model->received_at = date("Y-m-d H:i:s");
    //     $model->save();
    //     return  $this->JsonResponse('');
    // }

    //扫码核销
    public function scanCodeVerifi(Request $request)
    {
        $mpTokenObj = new MpAaccessToken();
        $dateTime = new DateTime();
        $dateTime->setTimezone(new DateTimeZone('Asia/Shanghai'));
        $upload_time = $dateTime->format('Y-m-d\TH:i:s.vP');

        $verObj = $request->user();
        $code = $request->code ?? '';
        $orderObj = OrderInfoModel::where('verification_code', $code)->first();
        if (!$orderObj) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        //核销员所属门店
        $hx_store = $useObj->store_id ?? 0;
        if ($verObj->role_id != 2 || $orderObj->store_id != $hx_store) {
            //return $this->JsonResponse('', '核销码不匹配门店', 500);
        }

        Log::add('核销操作', [$orderObj->verification_at]);
        if (!$orderObj->verification_at) {
            $orderObj->order_status = 3;
            $orderObj->verifier_id = $verObj->id;
            $orderObj->verifier = $verObj->name;
            $orderObj->verification_at = date("Y-m-d H:i:s");

            //查询是否纯积分抵扣订单
            if ($orderObj->pay_type == 2) {
                //积分抵扣，直接核销退出
                Log::add('scanCodeVerifi-point', $orderObj);
                $orderObj->save();
                Log::add('核销操作', $orderObj->toArray());
                return  $this->JsonResponse('');
            }


            //$orderObj->save();
            try {
                //接入微信小程序发货管理
                Log::add('scanCodeVerifi', $orderObj);
                //付款记录
                $recordObj = PaymentRecord::where('order_sn', $orderObj->order_sn)->first();
                if (!$recordObj) {
                    throw new Exception('该订单尚未支付');
                }
                $transaction_id = $recordObj->other_order;
                $payerOpenid = UserModel::where('id', $recordObj->uid)->value('openid');
                //商品信息
                $ogItem = DB::table('li_order_goods')
                    ->select(DB::raw('GROUP_CONCAT(goods_name) as shipping_goods'))
                    ->where('order_id', $orderObj->id)
                    ->first();

                $access_token = $mpTokenObj->getAccessToken();
                $url = "https://api.weixin.qq.com/wxa/sec/order/upload_shipping_info?access_token=" . $access_token;

                Log::add('发货录入url:', $url);
                $data = [
                    "order_key" => [
                        "order_number_type" => 2,
                        "transaction_id" => $transaction_id,
                    ],
                    "logistics_type" => 4, //4、用户自提
                    "delivery_mode" => 1, //1、（统一发货）
                    "shipping_list" => [
                        ["item_desc" => $ogItem->shipping_goods]
                    ],
                    "upload_time" => $upload_time,
                    "payer" => [
                        "openid" => $payerOpenid,
                    ]
                ];

                $result = curl_post_request($url, $data);
                Log::add('发货录入', $result);
                if ($result['errcode'] != 0) {
                    throw new Exception($result['errmsg']);
                } else {
                    $orderObj->shipping_type = 4;
                    $orderObj->shipping_goods = $ogItem->shipping_goods;
                    $orderObj->shipping_at = date("Y-m-d H:i:s");


                    //更新订单状态为解冻中，解冻7天（汇付会冻结1天），到期后分发佣金
                    $orderObj->freeze_end_date = date('Y-m-d H:i:s', strtotime('+6 day'));
                    $orderObj->save();

                    //更新积分状态为解冻中，解冻7天，到期后发放积分到账户积分余额
                    userPointChangeRec::pointUnfreezeimg($orderObj);
                }


                DB::commit();
            } catch (Exception $e) {
                DB::rollBack();
                return  $this->JsonResponse('', $e->getMessage(), 500);
            }
        } else {
            return  $this->JsonResponse('', '该码已核销，无需多次重复扫码', 500);
        }
        Log::add('核销操作', $orderObj->toArray());
        return  $this->JsonResponse('');
    }

    //扫码核销展示详情
    public function scanCodeDetail(Request $request)
    {
        $useObj = $request->user();
        $code = $request->code ?? '';
        $orderObj = OrderInfoModel::where('verification_code', $code)->first();
        if (!$orderObj) {
            Log::add('核销码', $code);
            return $this->JsonResponse('', '参数错误', 201);
        }
        //核销员所属门店
        $hx_store = $useObj->store_id ?? 0;
        if ($useObj->role_id != 2 || $orderObj->store_id != $hx_store) {
            //return $this->JsonResponse('', '核销码不匹配门店', 500);
        }
        $order_id = $orderObj->id;
        //商品信息
        $order_goods = $this->getOrderGoods($order_id);
        //快递待收点、收货地址
        $delivery = [];
        if ($orderObj->address) {
            $delivery['contacts'] = $orderObj->consignee;
            $delivery['phone'] = $orderObj->mobile;
            $delivery['area'] = $orderObj->area . "(" . $orderObj->address . ")";
            $delivery['lat'] = '';
            $delivery['lng'] = '';
        }
        if ($orderObj->store_id) {
            $sObj = Store::find($orderObj->store_id);
            $lat_lng = $sObj->lat_lng; //121.47,31.23
            $latlngArr = $lat_lng ? explode(",", $lat_lng) : [];
            $delivery['contacts'] = $sObj->contacts;
            $delivery['phone'] = $sObj->phone;
            $delivery['address'] = $sObj->address;
            $delivery['lat'] = isset($latlngArr[0]) ? $latlngArr[0] : '';
            $delivery['lng'] = isset($latlngArr[1]) ? $latlngArr[1] : '';
        }

        $data = [
            'id' => $order_id,
            'order_sn' => $orderObj->order_sn,
            'user_id' => $orderObj->user_id,
            'order_amount' => $orderObj->order_amount,
            //'mobile' => $orderObj->mobile,
            'delivery' => $delivery,
            'delivery_type' => $orderObj->delivery_type,
            'delivery_typename' => ($orderObj->delivery_type == 1) ? '快递代收点' : '送货上门',
            'created_at' => date("Y-m-d H:i:s", strtotime($orderObj->created_at)),
            'order_goods' => $order_goods
        ];
        return $this->JsonResponse($data);
    }

    //订单详情
    public function OrderInfo(Request $request)
    {
        $order_id = $request->order_id ?? 0;
        $order_sn = $request->order_sn ?? '';
        if (!$order_id && !$order_sn) {
            return $this->JsonResponse('', '参数错误02', 201);
        } else if ($order_id) {
            $orderObj = OrderInfoModel::find($order_id);
        } else if ($order_sn) {
            $orderObj = OrderInfoModel::where('order_sn', $order_sn)->first();
        }

        if (!$orderObj) {
            return $this->JsonResponse('', '订单不存在', 201);
        }


        $user_id = $request->user_id;
        //如果传入user_id 则查询该用户的订单，验证当前用户是否核销员
        if (!$user_id) {
            $user_id = $request->user()->id;
        }

        // if ($orderObj->user_id != $user_id) {
        //     return $this->JsonResponse('', '非本人订单', 201);
        // }

        //商品信息
        $order_goods = $this->getOrderGoods($order_id);
        //快递待收点、收货地址
        $delivery = [];
        if ($orderObj->consignee) {
            //$addressObj = UserAddress::find($orderObj->address_id);
            $delivery['contacts'] = $orderObj->consignee;
            $delivery['phone'] = $orderObj->mobile;
            $delivery['address'] = $orderObj->address;
            $delivery['area'] = $orderObj->area;
            // $delivery['lat'] = $addressObj->lat;
            // $delivery['lng'] = $addressObj->lng;
        }
        if ($orderObj->store_id) {
            $sObj = Store::find($orderObj->store_id);
            $lat_lng = $sObj->lat_lng; //121.47,31.23
            $latlngArr = $lat_lng ? explode(",", $lat_lng) : [];
            $delivery['contacts'] = $sObj->contacts;
            $delivery['phone'] = $sObj->phone;
            $delivery['address'] = $sObj->address;
            $delivery['lat'] = isset($latlngArr[0]) ? $latlngArr[0] : '';
            $delivery['lng'] = isset($latlngArr[1]) ? $latlngArr[1] : '';
        }
        //订单状态
        $order_status = $orderObj->order_status;
        $status_txt = OrderInfoModel::STATUS_OPTIONS[$order_status];

        $data = [
            'id' => $orderObj->id,
            'order_sn' => $orderObj->order_sn,
            'user_id' => $orderObj->user_id,
            'order_amount' => $orderObj->order_amount,
            'mobile' => $orderObj->mobile,
            'order_status' => $order_status,
            'status_txt' => $status_txt,
            'verification_code' => $orderObj->verification_code ?? '',
            'delivery' => $delivery,
            'delivery_type' => $orderObj->delivery_type,
            'delivery_typename' => ($orderObj->delivery_type == 1) ? '快递代收点' : '送货上门',
            'created_at' => date("Y-m-d H:i:s", strtotime($orderObj->created_at)),
            'order_goods' => $order_goods
        ];
        return $this->JsonResponse($data);
    }

    //订单商品信息
    private function getOrderGoods($oid)
    {
        $order_goods = [];
        $ogoods = OrderGoods::where(["order_id" => $oid])->get();
        foreach ($ogoods as $key => $valObj) {
            $tmp = [];
            $tmp['og_id'] = $valObj->id;
            $tmp['goods_id'] = $valObj->goods_id;
            $tmp['goods_name'] = $valObj->goods_name;
            $tmp['goods_number'] = $valObj->goods_number;
            $tmp['goods_attr'] = $valObj->goods_attr;
            $tmp['goods_price'] = $valObj->goods_price;
            $tmp['is_comment'] = $valObj->is_comment;
            $tmp['goods_img'] = $valObj->goods_img ? togetherFilePath($valObj->goods_img) : '';
            array_push($order_goods, $tmp);
        }
        return $order_goods;
    }

    //购物车确认订单
    public function CheckoutCartOrder(Request $request)
    {
        $cartKey = $request->cartKey ?? ''; //商品ID拼接 5_1,6_1
        if (!$cartKey) {
            return $this->JsonResponse('', '请选择购物车商品', 500);
        }
        $gidArr = explode(",", $cartKey);
        $user = $request->user();
        $shoppingCart = $user->shopping_cart ? json_decode($user->shopping_cart, true) : [];
        $data = [];
        foreach ($shoppingCart as $kk => $item) {
            $tmp = [];
            if (!in_array($kk, $gidArr)) {
                continue;
            }
            $goodsObj = GoodModel::find($item['goods_id']);
            $tmp['catKey'] = $kk;
            $tmp['goods_id'] = $item['goods_id'];
            $tmp['goods_name'] = $goodsObj->goods_name;
            $tmp['num'] = $item['num'];
            $tmp['goods_price'] = sprintf('%.2f', $item['goods_price']);
            $tmp['attr_name'] = $item['attr_txt'];
            $tmp['goods_img'] = $goodsObj->cover_img ? togetherFilePath($goodsObj->cover_img) : '';
            $tmp['attr_id'] = $item['attr_id'];

            array_push($data, $tmp);
        }
        return $this->JsonResponse($data);
    }

    //商户端首页统计
    public function orderCollect(Request $request)
    {
        $muser = $request->user();
        $merchant_id = $muser->merchant_id;
        //订单状态 0:待付款 1:待到货 2:待领取 3: 待评价 4:已完成  7:已取消 8:已退款
        $where = ['merchant_id' => $merchant_id];
        $firstDayOfMonth = date('Y-m-01 00:00:00'); // 00:00:00
        $lastDayOfMonth = date("Y-m-t 23:59:59", time());
        //本月数据统计
        $currentMonth = [];
        $currentMonth['buyCount'] = OrderInfoModel::where($where)->where('pay_status', 1)->whereBetween('created_at', [$firstDayOfMonth, $lastDayOfMonth])->count();
        $currentMonth['pickedCount'] = OrderInfoModel::where($where)->where('pay_status', 1)->whereIn('order_status', [3, 4])->whereBetween('created_at', [$firstDayOfMonth, $lastDayOfMonth])->count();
        $currentMonth['waitCount'] = OrderInfoModel::where($where)->where('pay_status', 1)->where("order_status", 2)->whereBetween('created_at', [$firstDayOfMonth, $lastDayOfMonth])->count();
        $currentStock = MerchantGoodSku::where($where)->sum('stock');
        $currentMonth['stockCount'] = $currentStock;

        //上月数据统计
        $lastMonth = [];
        if (date('d') < 10) {
        }
        $firstDayOfLastMonth = date('Y-m-01 00:00:00', strtotime('-1 month', time()));
        $ninthDayOfLastMonth = date('Y-m-t 23:59:59', strtotime('-1 month', time()));
        $lastMonth['buyCount'] = OrderInfoModel::where($where)->where('pay_status', 1)->whereBetween('created_at', [$firstDayOfLastMonth, $ninthDayOfLastMonth])->count();
        $lastMonth['pickedCount'] = OrderInfoModel::where($where)->where('pay_status', 1)->whereIn('order_status', [3, 4])->whereBetween('created_at', [$firstDayOfLastMonth, $ninthDayOfLastMonth])->count();
        $lastMonth['waitCount'] = OrderInfoModel::where($where)->where('pay_status', 1)->where("order_status", 2)->whereBetween('created_at', [$firstDayOfLastMonth, $ninthDayOfLastMonth])->count();
        //本月订单商品销量
        $goods_number = OrderGoods::where(['merchant_id' => $merchant_id, 'is_pay' => 1])
            ->whereBetween('created_at', [$firstDayOfMonth, $lastDayOfMonth])->sum('goods_number');
        $lastMonth['stockCount'] = $goods_number + $currentStock;

        return $this->JsonResponse(['current' => $currentMonth ? $currentMonth : new \stdClass(), 'last' => $lastMonth ? $lastMonth : new \stdClass()]);
    }





    //手动刷新token
    public function refreshTokenLYK(Request $request)
    {
        $mpTokenObj = new MpAaccessToken();
        $access_token = $mpTokenObj->getAccessToken(true);
        return $this->JsonResponse($access_token);
    }






    /**
     * 轮询查询解冻结束的积分，改成已完成，积分转入余额
     * @param Request $request HTTP请求对象
     * @return \Illuminate\Http\JsonResponse 返回JSON响应
     * 
     * 功能说明：
     * 1. 查询所有解冻中(point_state=2)且解冻结束日期小于当前时间的积分记录
     * 2. 将这些记录的状态更新为已完成(point_state=1)
     * 3. 将对应的积分金额转入用户余额
     * 
     * 使用示例：
     * GET /api/order/point-unfreeze-complete
     * 
     * 注意事项：
     * 1. 需要定时调用此接口(如每分钟或每小时)
     * 2. 操作在事务中进行，保证数据一致性
     * 3. 记录操作日志以便追踪
     */
    public function pointUnfreezeComplete(Request $request)
    {
        DB::beginTransaction();
        try {
            // 查询需要处理的积分记录
            $records = DB::table('user_point_change_rec')
                ->where('point_state', 2) // 解冻中
                ->where('freeze_end_date', '<=', date('Y-m-d H:i:s')) // 解冻已结束
                ->get();

            if ($records->isEmpty()) {
                Log::add('point_unfreeze_complete', '没有需要处理的解冻积分记录');
                return $this->JsonResponse([], '没有需要处理的解冻积分记录');
            }

            foreach ($records as $record) {
                // 更新记录状态为已完成
                DB::table('user_point_change_rec')
                    ->where('id', $record->id)
                    ->update([
                        'point_state' => 1, // 已完成
                        'updated_at' => date('Y-m-d H:i:s')
                    ]);

                // 将积分转入用户余额
                $user = UserModel::find($record->user_id);
                $user->balance += $record->point_amount;
                $user->save();

                Log::add('point_unfreeze_complete', [
                    'user_id' => $record->user_id,
                    'point_amount' => $record->point_amount,
                    'record_id' => $record->id
                ]);
            }

            DB::commit();
            return $this->JsonResponse([
                'processed_count' => count($records)
            ], '解冻积分处理完成');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::add('point_unfreeze_complete_error', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
            return $this->JsonResponse([], '解冻积分处理失败', 500);
        }
    }
}
