<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Models\PersonalAccessToken;
use App\Models\User;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\Adapay;
use App\Models\OrderInfo;
use App\Models\UserPointChangeRec;


class LoginController extends BaseController
{

    /**
     * 检验数据的真实性，并且获取解密后的明文.
     * @param $encryptedData string 加密的用户数据
     * @param $iv string 与用户数据一同返回的初始向量
     * @param $data string 解密后的原文
     *  *    <li>-41001: encodingAesKey 非法</li>
     *    <li>-41003: aes 解密失败</li>
     *    <li>-41004: 解密后得到的buffer非法</li>
     *    <li>-41005: base64加密失败</li>
     *    <li>-41016: base64解密失败</li>
     * @return int 成功0，失败返回对应的错误码
     */
    private function decryptData($sessionKey, $encryptedData, $iv, &$data)
    {
        if (strlen($sessionKey) != 24) {
            return '-41001';
        }
        $aesKey = base64_decode($sessionKey);
        if (strlen($iv) != 24) {
            return '-41002';
        }
        $aesIV = base64_decode($iv);

        $aesCipher = base64_decode($encryptedData);
        $result = openssl_decrypt($aesCipher, "AES-128-CBC", $aesKey, 1, $aesIV);
        //var_dump($result);exit;
        $dataObj = json_decode($result);
        if ($dataObj  == NULL) {
            return '-41003';
        }
        //        $appid = config('-wxsite.wx_xcx_appid');
        //        if( $dataObj->watermark->appid != $appid )
        //        {
        //            return '-41003';
        //        }
        $data = $dataObj;
        return '0';
    }


    public function getOpenid(Request $request)
    {
        $appid = env('WX_XCX_APPID');
        $secret = env('WX_XCX_KEY');
        $jsCode = $request->js_code ?? '';
        $url = 'https://api.weixin.qq.com/sns/jscode2session?appid=' . $appid . '&secret=' . $secret . '&js_code=' . $jsCode . '&grant_type=authorization_code';
        $wx_data = json_decode(file_get_contents($url), true);
        if (isset($wx_data['errcode'])) {
            Log::add('getOpenid请求微信接口异常', $wx_data,$request);
            return $this->JsonResponse('', '请求微信接口异常', 201);
        }
        return $this->JsonResponse([
            'session_key' => $wx_data['session_key'],
            'openid' => $wx_data['openid']
        ]);
    }

    //用户端登录
    public function login(Request $request)
    {
        $code = $request->code ?? '';
        $iv = $request->iv ?? '';
        //$openId = $request->openid ?? '';
        $encryptedData = $request->encryptedData ?? '';

        $result = $this->codeToSession($code);
        if (isset($result['errcode'])) {
            return $this->JsonResponse('', $result['errmsg'], 201);
        }
        $openId = $result['openid'];
        $session_key = $result['session_key'];

        $res = $this->decryptData($session_key, $encryptedData, $iv, $data);
        if ($res != 0) {
            Log::add('登录截取结果', $res);
            return $this->JsonResponse('', '参数异常' . $res, 201);
        }
        $user = User::where(['phone' => $data->phoneNumber])->first();
        if (!$user) {
            $user = new User();
            $user->name = 'wx_' . uniqid();
            $user->openid = $openId;
            $user->phone = $data->phoneNumber;
            $user->balance = 0;
            $user->freeze_balance = 0;
            $user->total_revenue = 0;
            $user->save();
        }
        // //对接汇付-创建个人对象【普通小程序用户已经不用绑定汇付了】
        // if (!$user->member_id) {
        //     $result = (new Adapay())->createMember(uid: $user->id, $user->phone);
        //     if (isset($result['status']) && $result['status'] == 'succeeded') {
        //         DB::table('users')->where('id', $user->id)->update(['member_id' => $result['member_id']]);
        //     }
        // }

        //生成token
        $accessToken = 'Bearer ' . $user->createToken('Access-token')->plainTextToken;
        $return = $this->JsonResponse([
            'Authorization' => $accessToken,

        ]);
        Log::add('用户--' . $user->id . '登录', '返回值：'.$return,$request);
        return $return;
    }

    //商户端授权绑定账号密码(提现时)
    public function merchantLogin(Request $request)
    {
        $muser = $request->user();
        $appid = env('XCX_MERCHENT_APPID');
        $secret = env('XCX_MERCHENT_SECRET');
        $code = $request->code ?? '';

        if (!$code) {
            return $this->JsonResponse('', '参数Code不能为空', 201);
        }
        DB::beginTransaction();
        try {
            $url = 'https://api.weixin.qq.com/sns/jscode2session?appid=' . $appid . '&secret=' . $secret . '&js_code=' . $code . '&grant_type=authorization_code';
            $result = json_decode(file_get_contents($url), true);
            if (isset($result['errcode'])) {
                Log::add('商户端授权请求微信接口异常', $result);
                throw new \Exception($result['errmsg']);
            }

            $openId = $result['openid'];
            if (!$muser->openid && $openId) {
                $muser->openid = $openId;
                $muser->save();
            }
            DB::commit();
        } catch (\Exception $exception) {
            DB::rollBack();
            return $this->JsonResponse('', $exception->getMessage(), 201);
        }

        return $this->JsonResponse('');
    }

    public function logout(Request $request)
    {
        $request->user()->tokens()->delete();
        //PersonalAccessToken::where(['tokenable_id' => $request->user()->id])->delete();
        return $this->JsonResponse('');
    }

    private function codeToSession($code)
    {
        $appid = env('WX_XCX_APPID');
        $secret = env('WX_XCX_KEY');
        if (!$code) {
            $this->error('无效参数Code');
        }
        $url = 'https://api.weixin.qq.com/sns/jscode2session?appid=' . $appid . '&secret=' . $secret . '&js_code=' . $code . '&grant_type=authorization_code';
        $wx_data = json_decode(file_get_contents($url), true);

        //Log::add('url：', $url);
        if (isset($wx_data['errcode'])) {
            Log::add('codeToSession请求微信接口异常', $wx_data);
            //return $this->JsonResponse('', '请求微信接口异常', 201);
        }
        return $wx_data;
    }

    public function testLogin(Request $request)
    {
        $uid = $request->uid ?? 7;
        $user = User::find($uid);
        $accessToken = 'Bearer ' . $user->createToken('Access-token')->plainTextToken;

        // //对接汇付-创建个人对象
        // if (!$user->member_id) {
        //     (new Adapay())->createMember($user->id, $user->phone);
        // }
        return $this->JsonResponse(['Authorization' => $accessToken,]);
    }


    
    // 模拟登陆
    public function simulateLogin(Request $request)
    {
        // 从请求中获取用户 ID
        $userId = $request->input('user_id');

        // 根据用户 ID 查找用户
        $user = User::find($userId);

        // 检查用户是否存在
        if (!$user) {
            return $this->JsonResponse('', '用户不存在', 201);
        }

        // 生成访问令牌
        $accessToken = 'Bearer ' . $user->createToken('Access-token')->plainTextToken;

        // 记录日志
        Log::add('用户--' . $user->id . '模拟登录', ['token' => $accessToken]);

        // 返回包含 Authorization 信息的响应
        return $this->JsonResponse([
            'Authorization' => $accessToken
        ]);
    }


    

    public function test(Request $request)
    {
        // $id = $request->id ?? 7;
        // $orderObj= OrderInfo::find($id);
        
        //userPointChangeRec::pointUnfreezeimg($orderObj);

        $result = (new Adapay())->createMember(78, '18173329012');

        return $this->JsonResponse(['data' => $result]);
    }



}
