<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Handlers\FileUploadHandler;
use App\Models\Comment;
use App\Models\CommentTpl;
use App\Jobs\AutoCompleteOrder;
use App\Models\OrderGoods;
use App\Models\OrderInfo;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class CommentController extends BaseController
{
    public function add(Request $request)
    {
        $useObj = $request->user();
        $og_id = $request->og_id ?? 0;
        $star = $request->star ?? 0;
        $content = $request->content ?? '';

        $ogObj = OrderGoods::find($og_id);
        if (!$ogObj) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        $oid = $ogObj->order_id;
        $orderObj = OrderInfo::find($oid);

        DB::beginTransaction();
        try {
            $comObj = new Comment();

            $comObj->og_id = $og_id;
            $comObj->goods_id = $ogObj->goods_id;
            $comObj->star = $star;
            $comObj->content = $content;
            $comObj->nickname = $useObj->name;
            $comObj->avatar = $useObj->avatar ?? '';
            $comObj->phone = $useObj->phone;
            if ($comObj->save()) {
                //更新评论状态
                $ogObj->is_comment = 1;
                $ogObj->save();
            }

            //2分钟执行订单分佣
            $count = OrderGoods::where('order_id', $oid)->where('is_comment', 0)->count();
            Log::add('订单商品评论' . $og_id, ['num' => $count]);
            if ($count == 0) {
                $orderObj->is_commission = 1;
                $orderObj->order_status = 4;
                $orderObj->save();
                // Log::add('调用分佣', $orderObj->toArray());
                // $this->dispatch(new AutoCompleteOrder($orderObj, 10));
            }
            DB::commit();
            return $this->JsonResponse('');
        } catch (\Exception $exception) {
            Log::add('添加评论失败', $exception->getMessage());
            DB::rollBack();
            return $this->JsonResponse('', '添加评论失败', 201);
        }
    }

    public function getList(Request $request)
    {
        $gid = $request->gid ?? 0;
        $page = $request->page ?? 1;
        $limit = $request->limit ?? 10;
        $sql = Comment::where(['goods_id' => $gid, 'deleted_at' => null])
            ->select('id', 'nickname', 'avatar', 'content', 'addtime');
        $data = [
            'total' => $sql->count(),
            'total_page' => ceil($sql->count() / $limit),
            'list' => []
        ];
        $listData = $sql->offset(($page - 1) * $limit)->limit($limit)->orderBy('created_at', 'DESC')->get();
        if ($listData->toArray()) {
            foreach ($listData as $item) {
                $data['list'][] = [
                    'id' => $item->id,
                    'nickname' => $item->nickname,
                    'avatar' => $item->avatar ? env('IMAGE_URL') . $item->avatar : '',
                    'content' => $item->content,
                    'addtime' => $item->addtime,
                ];
            }
        }
        return $this->JsonResponse($data);
    }
}
