<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Api\BaseController;
use App\Models\Category as CategoryModel;
use Illuminate\Http\Request;

class CategoryController extends BaseController
{
    public function getList(Request $request)
    {
        $parent_id = $request->parent_id ?? 0;
        $limit = $request->parent_id ?? 50;
        $data = [
            'list' => []
        ];
        $model = CategoryModel::select(['id', 'parent_id', 'title', 'icon'])
            ->where(['show' => 1, 'parent_id' => $parent_id])
            ->orderBy("order", "asc");

        $listData = $model->limit($limit)->get();
        if ($listData->toArray()) {
            foreach ($listData as $item) {
                $data['list'][] = [
                    'id' => $item->id,
                    'parent_id' => $item->parent_id,
                    'title' => $item->title,
                    //'icon' => (isset($item->icon) ? env('IMAGE_URL') . $item->icon : '')
                ];
            }
        }
        array_unshift($data['list'], ['id' => 0, 'parent_id' => 0, 'title' => '全部']);
        return $this->JsonResponse($data);
    }

    public function getAllList(Request $request)
    {
        $cat_id = $request->cat_id ?? 0;
        $data = [];
        $catList = CategoryModel::where(['show' => 1, 'parent_id' => 0])->select("id", 'title', 'brief', 'icon', 'imgUrl', 'is_explore', 'explore', 'linkUrl')->get();
        if (!$catList) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        foreach ($catList as $key => $val) {

            $tmp = [];
            $tmp['id'] = $val->id;
            $tmp['title'] = $val->title;
            $tmp['brief'] = $val->brief ?? '';
            $tmp['cover'] = (isset($val->icon) ? env('IMAGE_URL') . $val->icon : '');
            $tmp['imgUrl'] = (isset($val->imgUrl) ? env('IMAGE_URL') . $val->imgUrl : '');
            $tmp['is_explore'] = $val->is_explore ?? 0;
            $tmp['explore'] = $val->explore ?? '';
            $tmp['linkUrl'] = $val->linkUrl ?? '';
            $tmp['list'] = [];
            $seclist = CategoryModel::select(['id', 'parent_id', 'title', 'icon'])
                ->where(['show' => 1, 'parent_id' => $val->id])->get();
            foreach ($seclist as $kk => $vv) {
                $secArr = [
                    'id' => $vv->id,
                    'title' => $vv->title,
                    'cover' => (isset($vv->icon) ? env('IMAGE_URL') . $vv->icon : '')
                ];

                $tmp['list'][] = $secArr;
            }
            array_push($data, $tmp);
        }

        return $this->JsonResponse($data);
    }

    public function getSecList(Request $request)
    {
        $cat_id = $request->cat_id ?? 0;
        $data = $res = [];
        $catList = CategoryModel::where(['show' => 1, 'parent_id' => $cat_id])->select("id", 'title', 'parent_id')->get();
        if (!$catList) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        $catRows = $catList->toArray();
        array_unshift($catRows, ['id' => 0, 'parent_id' => $cat_id, 'title' => '全部']);
        return $this->JsonResponse($catRows);
    }

    public function getThirdList(Request $request)
    {
        $cat_id = $request->cat_id ?? 0;
        $pid = $request->pid ?? null;
        $catList = [];
        if ($cat_id) {
            $catList = CategoryModel::where(['show' => 1, 'parent_id' => $cat_id])
                ->select("id", 'title', 'icon as cover', 'parent_id')
                ->get()->toArray();
        }
        if ($pid) {
            $secList = CategoryModel::where(['show' => 1, 'parent_id' => $pid])
                ->select("id", 'title')
                ->get()
                ->toArray();
            if ($secList) {
                $secArr = [];
                foreach ($secList as $key => $val) {
                    array_push($secArr, $val['id']);
                }
                $catList = CategoryModel::whereIn("parent_id", $secArr)
                    ->select("id", 'title', 'icon as cover')
                    ->get()
                    ->toArray();
            }
        }
        foreach ($catList as $kk => &$vv) {
            $vv['cover'] = (isset($vv['cover']) ? env('IMAGE_URL') . $vv['cover'] : '');
        }
        // if (!$catList) {
        //     return $this->JsonResponse('', '参数错误', 201);
        // }
        return $this->JsonResponse($catList);
    }


    public function getSecList2(Request $request)
    {
        $cat_id = $request->cat_id ?? 0;
        $data = [
            'list' => []
        ];
        $cat = CategoryModel::where(['show' => 1, 'id' => $cat_id])->first();
        if (!$cat) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        $data['title'] = $cat->title;
        $data['cover'] = (isset($cat->icon) ? env('IMAGE_URL') . $cat->icon : '');
        //分类列表
        $model = CategoryModel::select(['id', 'parent_id', 'title', 'brief', 'icon'])
            ->where(['show' => 1, 'parent_id' => $cat_id]);

        $listData = $model->limit(50)->get();
        if ($listData->toArray()) {
            foreach ($listData as $item) {
                $data['list'][] = [
                    'id' => $item->id,
                    'parent_id' => $item->parent_id,
                    'title' => $item->title,
                    //'cover' => (isset($item->icon) ? env('IMAGE_URL') . $item->icon : '')
                ];
            }
        }
        return $this->JsonResponse($data);
    }
}
