<?php

/**
 * 含有中文数组排序
 */
function utf8_array_asort(&$array)
{
    if (!isset($array) || !is_array($array)) {
        return false;
    }
    foreach ($array as $k => $v) {
        $array[$k] = iconv('UTF-8', 'GBK//IGNORE', $v);
    }
    asort($array);
    foreach ($array as $k => $v) {
        $array[$k] = iconv('GBK', 'UTF-8//IGNORE', $v);
    }
    return true;
}

/**
 * 生成随机字符串
 */
function generateRandomString($length = 10)
{
    $characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}


function togetherFilePath($path = '')
{
    if ($path) {
        if (strstr($path, 'aliyuncs') === false) {
            $path = env('IMAGE_URL') . $path;
        }
    }
    return $path;
}


function curl_post_request($url, $data)
{
    $headers = array("Content-type: application/json;charset=UTF-8");

    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
    // 设置HTTP头部
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data, JSON_UNESCAPED_UNICODE));
    $response = curl_exec($curl);

    $result = json_decode($response, true);
    // 关闭cURL会话
    curl_close($curl);
    return $result;
}
