<?php

namespace App\Admin\Renderable;


use App\Models\Store;
use App\Models\Good as GoodModel;
use App\Models\Category;
use Dcat\Admin\Grid;
use Dcat\Admin\Grid\LazyRenderable;

class StoreList extends LazyRenderable
{
    public function grid(): Grid
    {
        // 获取外部传递的参数
        $merchant_id = $this->payload['merchant_id'] ?? [];

        return Grid::make(new Store(), function (Grid $grid) use ($merchant_id) {

            $grid->addTableClass(['table-text-center']);
            $grid->model()->where('merchant_id', $merchant_id);
            $grid->column('title', '门店名称');
            $grid->column('lat_lng', '经纬度');
            $grid->column('address', '详细地址');
            $grid->column('distance', '配送范围')->display(function ($val) {
                return $val > 0 ? $val . " 公里" : '';
            });


            $grid->disableCreateButton();
            $grid->disableRefreshButton();
            $grid->disablePagination();
            $grid->disableViewButton();
            $grid->disableEditButton();
            $grid->disableRowSelector();
            $grid->disableDeleteButton();
            $grid->disableActions();
            //屏蔽删除
            //$grid->actions(new DeleteService());
        });
    }
}
