<?php

namespace App\Admin\Metrics\Examples;

use App\Models\User;
use Dcat\Admin\Widgets\Metrics\Round;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Dcat\Admin\Widgets\Metrics\Line;
use Dcat\Admin\Widgets\Card;
use Dcat\Admin\Widgets\Table;

class Product extends Line
{
    /**
     * 初始化卡片内容
     */
    protected function init()
    {
        parent::init();

        //$this->title('Product Orders');
        //$this->chartLabels(['Finished', 'Pending', 'Rejected']);
        // $this->dropdown([
        //     '7' => 'Last 7 Days',
        //     '28' => 'Last 28 Days',
        //     '30' => 'Last Month',
        //     '365' => 'Last Year',
        // ]);
    }

    /**
     * 处理请求
     *
     * @param Request $request
     *
     * @return mixed|void
     */
    public function handle(Request $request)
    {
        switch ($request->get('option')) {
            case '365':
            case '30':
            case '28':
            case '7':
            default:
                $list = DB::table('li_goods')->where('is_show', 1)->where('sale', '>', 0)->orderBy('sale', 'desc')->limit(10)->get();
                $html = '';
                foreach ($list as $kk => $vv) {
                    $html .= '<tr>';
                    $html .= '<td style="width:20%;text-align:left;"><img src="' . togetherFilePath($vv->cover_img) . '" width="100"></td>';
                    $html .= '<td style="width:36%;text-align:left;">' . $vv->goods_name . '</td>';
                    $html .= '<td style="width:33%;">销量：' . $vv->sale . '</td>';
                    $html .= '</tr>';
                }
                // 卡片内容
                $this->withContent(23043, $html);


                // 图表数据
                //$this->withChart([70, 52, 26]);

                // 总数
                $this->chartTotal('Total', 344);
        }
    }

    /**
     * 设置图表数据.
     *
     * @param array $data
     *
     * @return $this
     */
    public function withChart(array $data)
    {
        return $this->chart([
            'series' => $data,
        ]);
    }

    /**
     * 卡片内容.
     *
     * @param int $finished
     * @param int $pending
     * @param int $rejected
     *
     * @return $this
     */
    public function withContent($finished, $dataList)
    {
        // $card2 = Card::make('自定义数据列表2')
        //     ->content(Table::make(User::query(), function ($table) {
        //         // 自定义列表字段
        //         $table->columns('id', 'email', 'created_at');
        //         // 启用分页
        //         $table->paginate(10);
        //     }));

        return $this->content(
            <<<HTML
 <div class="col-sm-12 d-flex flex-column flex-wrap text-center">
<table border="0" cellpadding="8" style="width:98%;border-spacing:8px;margin-bottom:15px;"> 
  {$dataList}
</table>
</div> 
HTML
        );
    }
}
