<?php

namespace App\Admin\Forms;


use App\Models\Performance;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Dcat\Admin\Widgets\Form;


class EditParameter extends Form  implements LazyRenderable
{
    use LazyWidget;
    /**
     * Handle the form request.
     *
     * @param array $input
     *
     * @return mixed
     */
    public function handle(array $input)
    {

        $model = Performance::find($this->payload['id']);
        $params = [];
        for($i=1;$i<=10;$i++){
            $params[] = $input['param'.$i];
        }
        $model->parameter = json_encode($params,JSON_UNESCAPED_UNICODE);
        if(!$model->save()){
            return $this
                ->response()
                ->error('修改参数失败')
                ->refresh();
        }
        return $this
            ->response()
            ->success('修改参数成功.')
            ->refresh();
    }

    /**
     * Build a form here.
     */
    public function form()
    {
        $this->text('param1','参数1');
        $this->text('param2','参数2');
        $this->text('param3','参数3');
        $this->text('param4','参数4');
        $this->text('param5','参数5');
        $this->text('param6','参数6');
        $this->text('param7','参数7');
        $this->text('param8','参数8');
        $this->text('param9','参数9');
        $this->text('param10','参数10');
    }

    /**
     * The data of the form.
     *
     * @return array
     */
    public function default()
    {
        $params = Performance::find($this->payload['id'])->parameter;
        $params = $params ? json_decode($params) : [];
        return [
            'param1'  => $params[0] ?? '',
            'param2'  => $params[1] ?? '',
            'param3'  => $params[2] ?? '',
            'param4'  => $params[3] ?? '',
            'param5'  => $params[4] ?? '',
            'param6'  => $params[5] ?? '',
            'param7'  => $params[6] ?? '',
            'param8'  => $params[7] ?? '',
            'param9'  => $params[8] ?? '',
            'param10'  => $params[9] ?? '',
        ];
    }
}
