<?php

namespace App\Admin\Controllers;

use App\Models\UserBuycodeCheck;
use App\Admin\Forms\CheckBuycode;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;

class UserBuycodeCheckController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(UserBuycodeCheck::with(['user']), function (Grid $grid) {
            $grid->model()->orderBy('created_at', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('user.avatar', '用户头像')->image('', 100, 100);
            $grid->column('user.name', '用户昵称');
            $grid->column('user.phone', '手机号');
            $grid->column('before_code');
            $grid->column('after_code');
            $grid->column('status')
                ->using(UserBuycodeCheck::STATUS)->dot([
                    0 => 'primary',
                    1 => 'success',
                    2 => 'danger'
                ])
                ->if(function ($column) {
                    return $column->getValue() == 0;
                })->display('点击审批')->modal(function (Grid\Displayers\Modal $modal) {
                    // 标题
                    $modal->title('直购码审核');
                    // 自定义图标
                    $modal->icon('feather icon-edit');
                    // 传递当前行字段值
                    return CheckBuycode::make()->payload(['id' => $this->id]);
                });
            // $grid->column('created_at');
            // $grid->column('updated_at')->sortable();
            $grid->disableCreateButton();
            $grid->disableActions();
            $grid->disableRowSelector();
            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->equal('user.nickname', '用户昵称')->width(4);
                $filter->like('user.phone', '手机号')->width(4);
                $filter->equal('status', '审核状态')->select(['0' => '待审核', '1' => '已通过', '2' => '已驳回'])->width(3);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new UserBuycodeCheck(), function (Show $show) {
            $show->field('id');
            $show->field('before_code');
            $show->field('after_code');
            $show->field('status');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new UserBuycodeCheck(), function (Form $form) {
            $form->display('id');
            $form->text('before_code');
            $form->text('after_code');
            $form->text('status');

            $form->display('created_at');
            $form->display('updated_at');
        });
    }
}
