<?php

namespace App\Admin\Controllers;

use App\Handlers\AliOss;
use OSS\Core\OssException;
use Dcat\Admin\Traits\HasUploadedFile;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use App\Models\Adapay;

class UploadController
{

    use HasUploadedFile;

    /**
     * 删除OSS私有桶资源文件
     */
    public function deleteOssFile()
    {
        $ossPath = request()->post('key') ?? '';
        $aliOss = new AliOss();
        $res = $aliOss->delete($ossPath);
        return $res ? $this->responseDeleted() : $this->responseDeleteFailed('文件删除失败');
    }

    /**
     * 删除OSS公有桶资源文件
     */
    public function deletePublicOssFile()
    {
        $ossPath = request()->post('key') ?? '';
        $aliOss = new AliOss();
        if (strstr($ossPath, 'aliyuncs') !== false) {
            $res = $aliOss->delete($ossPath); //, 'OSS_BUCKET'
            return $res ? $this->responseDeleted() : $this->responseDeleteFailed('文件删除失败');
        } else {
            return $this->deleteFileAndResponse();
        }
    }

    public function merchantUpload()
    {
        $disk = $this->disk();

        // 判断是否是删除文件请求
        if ($this->isDeleteRequest()) {

            // 删除文件并响应
            return $this->deleteFileAndResponse();
        }

        // 获取上传的文件
        $file = $this->file();
        //获取文件扩展名
        $ext = $file->getClientOriginalExtension();
        $img  = Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode($ext, 90);

        $dir     = '/merchant/' . date("Ymd");
        $newName = md5(uniqid()) . '.' . $ext;

        $path   = "{$dir}/$newName";
        $result = $disk->put($path, $img);

        return $result
            ? $this->responseUploaded($path, $disk->url($path))
            : $this->responseErrorMessage('文件上传失败');
    }


    public function userUpload()
    {
        $disk = $this->disk();

        // 判断是否是删除文件请求
        if ($this->isDeleteRequest()) {

            // 删除文件并响应
            return $this->deleteFileAndResponse();
        }

        // 获取上传的文件
        $file = $this->file();
        //获取文件扩展名
        $ext = $file->getClientOriginalExtension();
        $img  = Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode($ext, 90);

        $dir     = '/user';
        $newName = md5(uniqid()) . '.' . $ext;

        $path   = "{$dir}/$newName";
        $result = $disk->put($path, $img);

        return $result
            ? $this->responseUploaded($path, $disk->url($path))
            : $this->responseErrorMessage('文件上传失败');
    }

    /**
     * 上传资源库图片
     */
    public function goodsUpload()
    {
        $aliOss = new AliOss();

        // 判断是否是删除文件请求
        if ($this->isDeleteRequest()) {
            // 删除文件并响应
            return $this->deleteFileAndResponse();
        }

        // 获取上传的文件
        $file = $this->file();

        // 检查文件是否存在
        if (!$file) {
            return $this->responseErrorMessage('文件不存在');
        }

        $ext = $file->getClientOriginalExtension();
        Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode('jpg', 90);

        $fileName = md5(uniqid()) . '.' . $ext;
        $date = date('Ymd');
        $ossFilePath =  'goods/' . $date . '/' . $fileName;
        //获取文件的绝对路径
        $path = $file->getRealPath();
        $res = $aliOss->upload($ossFilePath, $path, 'OSS_PUBLIC_BUCKET');

        return $res
            ? $this->responseUploaded(env('OSS_PUBLIC_IMAGE_URL') . $ossFilePath, '')
            : $this->responseErrorMessage('文件上传失败');
    }


    //商品规格图
    public function uploadSkuImage(Request $request)
    {
        $aliOss = new AliOss();
        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $disk = $this->disk();
            //获取文件扩展名
            $ext = $file->getClientOriginalExtension();

            $fileName = md5(uniqid()) . '.' . $ext;
            $date = date('Ymd');
            $path = $file->getRealPath();
            $ossFilePath =  'goods/' . $date . '/' . $fileName;
            $res = $aliOss->upload($ossFilePath, $path, 'OSS_PUBLIC_BUCKET');

            return ['url' => env('OSS_PUBLIC_IMAGE_URL') . $ossFilePath];
        }
    }

    //轮播图
    public function carouselUpload()
    {
        $aliOss = new AliOss();

        // 获取上传的文件
        $file = $this->file();
        Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode('jpg', 90);

        $fileName = md5(uniqid()) . '.jpg';
        $date = date('Ymd');
        $ossFilePath =  'carousel/' . $date . '/' . $fileName;
        //获取文件的绝对路径
        $path = $file->getRealPath();
        $res = $aliOss->upload($ossFilePath, $path, 'OSS_PUBLIC_BUCKET');

        return $res
            ? $this->responseUploaded(env('OSS_PUBLIC_IMAGE_URL') . $ossFilePath, '')
            : $this->responseErrorMessage('文件上传失败');
    }

    //汇付图片(先调用汇付,再调用alioss)
    public function huifuUpload()
    {

        //汇付类型
        // $file_type = [
        //     'social_credit_code_id' => '01',
        //     'legal_cert_id_front_id' => '02',
        //     'legal_cert_id_back_id' => '03',
        // ];
        // $upload_column = $_POST['upload_column'] ?? '';

        $aliOss = new AliOss();
        // 获取上传的文件
        $file = $this->file();
        $ext = $file->getClientOriginalExtension();
        // Image::make($file->getRealPath())
        //     ->resize(640, null, function ($constraint) {
        //         $constraint->aspectRatio();
        //         $constraint->upsize();
        //     })->encode('jpg', 90);

        $fileName = uniqid() . '.' . $ext;
        $date = date('Ymd');
        $ossFilePath =  'huifu/' . $date . '/' . $fileName;
        //获取文件的绝对路径
        $path = $file->getRealPath();
        $res = $aliOss->upload($ossFilePath, $path, 'OSS_PUBLIC_BUCKET');

        return $res
            ? $this->responseUploaded(env('OSS_PUBLIC_IMAGE_URL') . $ossFilePath, '')
            : $this->responseErrorMessage('文件上传失败');
    }

    public function carouselUpload2()
    {
        $disk = $this->disk();

        // 判断是否是删除文件请求
        if ($this->isDeleteRequest()) {

            // 删除文件并响应
            return $this->deleteFileAndResponse();
        }

        // 获取上传的文件
        $file = $this->file();
        //获取文件扩展名
        $ext = $file->getClientOriginalExtension();
        $img  = Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode($ext, 90);

        $dir     = '/carousel';
        $newName = md5(uniqid()) . '.' . $ext;

        $path   = "{$dir}/$newName";
        $result = $disk->put($path, $img);

        return $result
            ? $this->responseUploaded($path, $disk->url($path))
            : $this->responseErrorMessage('文件上传失败');
    }

    public function articlelUpload()
    {
        $disk = $this->disk();

        // 判断是否是删除文件请求
        if ($this->isDeleteRequest()) {

            // 删除文件并响应
            return $this->deleteFileAndResponse();
        }

        // 获取上传的文件
        $file = $this->file();
        //获取文件扩展名
        $ext = $file->getClientOriginalExtension();
        $img  = Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode($ext, 90);

        $dir     = '/article';
        $newName = md5(uniqid()) . '.' . $ext;

        $path   = "{$dir}/$newName";
        $result = $disk->put($path, $img);

        return $result
            ? $this->responseUploaded($path, $disk->url($path))
            : $this->responseErrorMessage('文件上传失败');
    }
}
