<?php

namespace App\Admin\Controllers;

use App\Models\StoreAdminUsers;
use App\Models\Merchant;
use App\Models\Good;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Illuminate\Support\Facades\Hash;
use Dcat\Admin\Http\Controllers\AdminController;
use Illuminate\Support\Facades\DB;

class StoreAdminUsersController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(StoreAdminUsers::with(['merchant', 'store']), function (Grid $grid) {
            $grid->model()->where('role_id', 2); //2: 核销员
            $grid->model()->orderBy('created_at', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('name', '姓名');
            $grid->column('username', '登录账号');
            $grid->column('merchant.name', '所属商家');
            $grid->column('store.title', '所属门店');
            // $grid->column('created_at');
            // $grid->column('updated_at')->sortable();
            $grid->disableViewButton();
            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('name', '姓名')->width(3);
                $filter->like('username', '登录账号')->width(3);
                $filter->like('merchant.name', '所属商家')->width(3);
                $filter->like('store.title', '所属门店')->width(3);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        // return Show::make($id, new Verifier(), function (Show $show) {
        //     $show->field('id');
        //     $show->field('merchant_id');
        //     $show->field('store_id');
        //     $show->field('created_at');
        //     $show->field('updated_at');
        // });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form =  Form::make(new StoreAdminUsers(), function (Form $form) {
            $form->display('id');
            //$form->ignore(['pwd']); // 忽略password字段
            $form->text('name')->required();
            $form->text('username','登录账号')
                ->required()
                ->help('字母数字组合，长度大于5个字符')
                ->rules(function (Form $form) {
                    /**
                     * 用户名唯一性验证规则
                     * 功能：验证用户名是否已存在
                     * 参数：$form 表单实例
                     * 返回值：string 验证规则字符串
                     * 注意事项：编辑时排除当前记录
                     */
                    $rule = 'unique:store_admin_users,username';
                    if ($id = $form->model()->id) {
                        $rule .= ','.$id;
                    }
                    return $rule;
                }, [
                    'unique' => '该登录账号已被使用，请更换'
                ]);
            if ($form->isCreating()) {
                $form->password('password', '密码')->saving(function ($password) {
                    return bcrypt($password);
                })->help('字母数字组合，长度大于5个字符');
                // } else {
                //     $form->text('password', '密码')->help('密码为空则不修改');
                //     $form->password = '';
            }
            if ($form->isEditing()) {
                $form->text('pwd', '密码')->help('密码为空则不修改');
            }

            $form->hidden('role_id')->default(2); //核销员
            // 如果是创建模式，执行相关操作
            $form->select('merchant_id', '商家名称')
                ->options(Merchant::whereNull('deleted_at')->get()->pluck('name', 'id'))
                ->load('store_id', '/get-store-list');
            $form->select('store_id', '门店名称');

            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();
        });

        //副表保存规格
        $form->saved(
            function (Form $form, $result) {
                $store_admin_users_id = $form->getKey();
                $pwd = $form->model()->pwd;
                //更新信息
                if ($pwd) {
                    $data = ['password' => bcrypt($pwd), 'pwd' => ''];
                    DB::table('store_admin_users')->where("id", $store_admin_users_id)->update($data);
                }
            }
        );

        return $form;
    }
}
