<?php

namespace App\Admin\Controllers;

use App\Admin\Forms\EditPermission;
use App\Admin\Forms\updatePassword;
use Dcat\Admin\Grid\RowAction;
use App\Models\User;
use App\Models\UserPermission;
use Dcat\Admin\Admin;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;

use Dcat\Admin\Show;
use Illuminate\Http\Request;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Widgets\Select;

class ShareController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $uid = request()->get('id');
        $phone = request()->get('phone') ?? ''; //->orwhere('second_spuid', $uid)
        $name = request()->get('name') ?? '';
        $sp_type = request()->get('sp_type') ?? '';
        return Grid::make(User::with(['shuser']), function (Grid $grid) use ($uid, $phone, $name, $sp_type) {
            $grid->addTableClass(['table-text-center']);
            $where = [];
            if ($phone) {
                $where['phone'] = $phone;
            }
            if ($name) {
                $where['name'] = $name;
            }
            if ($phone || $name || $sp_type) {
                if ($sp_type == 1) {
                    $grid->model()->where('spuid', $uid)
                        ->where($where)
                        ->orderBy('created_at', 'DESC');
                } elseif ($sp_type == 2) {
                    $grid->model()->where('second_spuid', $uid)
                        ->where($where)
                        ->orderBy('created_at', 'DESC');
                } else {
                    $grid->model()->where('spuid', $uid)->orWhere('second_spuid', $uid)
                        ->where($where)
                        ->orderBy('created_at', 'DESC');
                }
            } else {
                $grid->model()->where('spuid', $uid)->orWhere('second_spuid', $uid)
                    ->orderBy('created_at', 'DESC');
            }


            //$grid->column('id')->sortable();
            $grid->column('name', '昵称');
            $grid->column('phone', '手机号');
            $grid->column('created_at', '注册时间')->display(function ($val) {
                return date("Y-m-d H:i:s", strtotime($this->created_at));
            });

            $grid->disableCreateButton();
            $grid->disableViewButton();
            $grid->disableDeleteButton();
            $grid->enableDialogCreate();
            $grid->disableEditButton();
            $grid->disableActions();
            $grid->disableRowSelector();
            //$grid->simplePaginate();

            $grid->filter(function (Grid\Filter $filter) use ($uid) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('name', '昵称')->width(3);
                $filter->like('phone', '用户手机号')->width(3);

                $filter->where('sp_type', function ($query) use ($uid) {}, '选项')->select(['1' => '直推', '2' => '间推'])->width(3);

                //$filter->between('created_at', '注册时间')->datetime()->width(4);
            });
        });
    }
    protected function getCustomFilterScript()
    {
        return <<<JS
        $('select[name="status"]').change(function() {
            var value = $(this).val();
            console.log('asdfadf'+value);
            
            Dcat.getData().filter('#your_custom_filter_field', 'value');
        });
JS;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new User(), function (Show $show) {
            $show->field('id');
            $show->field('name');
            $show->field('avatar');
            $show->field('openid');
            $show->field('phone');
            $show->field('status');
            $show->field('role');
            $show->field('department');
            $show->field('email');
            $show->field('email_verified_at');
            $show->field('password');
            $show->field('remember_token');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new User(), function (Form $form) {
            $form->text('name', '昵称');
            $form->switch('status', '状态')->default(1);
            // $form->image('avatar', '头像')
            //     ->url('upload/user-avatar')
            //     ->deleteUrl('upload/delete-public-cos-file')
            //     ->autoUpload();

            // if ($form->isCreating()) {

            //     $form->mobile('phone', '手机号')->rules('required|unique:users,phone', ['required' => '手机号码不可为空', 'unique' => '此手机号码已存在，请重新填写']);
            //     $form->text('password', '密码');
            // }

            // if ($form->isCreating()) {
            //     $form->saving(function (Form $form) {
            //         $form->password = bcrypt($form->password);
            //     });
            // }
        });
    }
}
