<?php

namespace App\Admin\Controllers;

use App\Models\PaymentRecord;
use App\Models\TotalOrder;
use App\Models\User;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;

class PaymentRecordController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(PaymentRecord::with(['user']), function (Grid $grid) {
            $grid->addTableClass(['table-text-center']);
            $grid->model()->orderBy('created_at', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('order_sn', '订单号');
            $grid->column('other_order', '外部订单ID');
            $grid->column('payment_id', '支付ID')->limit(10);
            $grid->column('party_order_id', '支付订单ID')->limit(10);
            $grid->column('money', '金额');
            $grid->column('uid', '用户ID');
            $grid->column('user.name', '用户');
            $grid->column('created_at', '支付时间');

            $grid->disableViewButton();
            $grid->disableEditButton();
            $grid->disableCreateButton();
            $grid->disableActions();
            $grid->simplePaginate();
           
            $grid->quickSearch('user.name')->placeholder('搜索用户');
            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel();

                // 用户ID筛选
                $filter->equal('uid', '用户ID')->width(3);

                // 用户名称筛选
                $filter->like('user.name', '用户名称')->width(3);

                // 订单号筛选
                $filter->like('order_sn', '订单号')->width(3);

                // 金额筛选
                $filter->between('money', '金额范围', function ($query) {
                    if (isset($this->input['min'])) {
                        $query->where('money', '>=', $this->input['min']);
                    }
                    if (isset($this->input['max'])) {
                        $query->where('money', '<=', $this->input['max']);
                    }
                })->width(4);

                // 时间区间筛选
                $filter->between('created_at', '支付时间')->datetime()->width(4);

                // 快捷时间筛选
                $filter->scope('today', '今日')->whereDate('created_at', date('Y-m-d'));
                $filter->scope('month', '本月')->whereMonth('created_at', date('m'));
                $filter->scope('year', '本年')->whereYear('created_at', date('Y'));
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new PaymentRecord(), function (Show $show) {
            $show->field('id');
            $show->field('pay_type');
            $show->field('order_id');
            $show->field('other_order');
            $show->field('money');
            $show->field('uid');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new PaymentRecord(), function (Form $form) {
            $form->display('id');
            $form->text('pay_type');
            $form->text('order_id');
            $form->text('other_order');
            $form->text('money');
            $form->text('uid');

            $form->display('created_at');
            $form->display('updated_at');
        });
    }
}
