<?php

namespace App\Admin\Controllers;

use App\Models\Merchant;
use App\Models\OrderDivideRecord;
use App\Models\User;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use App\Admin\Actions\TransferToPlatForm;
use App\Models\StoreAdminUsers;

class OrderDivideRecordController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(OrderDivideRecord::with(['order', 'users']), function (Grid $grid) {
            $grid->model()->orderBy('id', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('order.order_sn', '订单号');
            $grid->column('users.phone', '下单会员手机号');
            //$grid->column('og_id', '订单商品ID');
            $grid->column('order_price', '订单商品价格');
            $grid->column('proportion', '分佣比例');
            $grid->column('divide_price', '佣金');
            //$grid->column('proportion', '分佣比例%');
            $grid->column('sh_type', '分佣类型')->display(function ($val) {
                return OrderDivideRecord::COMMISSION_TYPE[$val];
            });
            $grid->column('is_div', '是否已分账')->display(function ($val) {
                return $val == 1 ? '是' : '否';
            });
            $grid->column('um_id', '商户/员工')->display(function ($val) {
                $stype = $this->sh_type;
                $name = '';
                if ($stype == 0) {
                    $name = '平台';
                } else if ($stype == 3) {
                    $name = Merchant::where('id', $val)->value('name');
                } else if ($stype == 5) {
                    $name = StoreAdminUsers::where('member_id', $val)->value('name');
                }

                return $name;
            });
            $grid->column('remark', '备注')->width(80);



            $grid->column('created_at');
            //$grid->column('updated_at')->sortable();

            $grid->disableCreateButton();
            $grid->disableViewButton();
            $grid->disableEditButton();
            $grid->disableDeleteButton();
            $grid->disableRowSelector();
            // 隐藏操作按钮
            $grid->disableActions(); // 隐藏所有操作按钮
            $grid->disableCreateButton(); // 隐藏新增按钮
            $grid->disableDeleteButton(); // 隐藏删除按钮

            // 添加导出字段映射
            $titles = [
                'id' => 'ID',
                'order.order_sn' => '订单号',
                'users.phone' => '会员手机号',
                'order_price' => '商品价格',
                'divide_price' => '分佣金额',
                'sh_type' => '分佣类型',
                'is_div' => '是否分账',
                'um_id' => '商户/员工',
                'created_at' => '创建时间'
            ];

            // 添加导出按钮
            $grid->export($titles)->rows(function ($rows) {
                foreach ($rows as $index => &$row) {
                    // 处理分佣类型显示
                    $row['is_div'] = $row['is_div'] == 1 ? '是' : '否';
                    $row['um_id'] = $row['um_id'] == 0 ? '平台' : $row['um_id'];

                    // 处理商家/员工显示
                    if ($row['sh_type'] == 0) {
                        $row['um_id'] = '平台';
                    } else if ($row['sh_type'] == 3) {
                        $row['um_id'] = Merchant::where('id',  $row['um_id'])->value('name');
                    } else if ($row['sh_type'] == 5) {
                        $row['um_id'] = StoreAdminUsers::where('member_id',  $row['um_id'])->value('name');
                    }

                    $row['sh_type'] = OrderDivideRecord::COMMISSION_TYPE[$row['sh_type']];
                }
                return $rows;
            });

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('order.order_sn', '订单号')->width(3);
                $filter->like('users.phone', '下单会员手机号')->width(3);
                // 修改分佣类型筛选为下拉选择
                $filter->equal('sh_type', '分佣类型')->select(OrderDivideRecord::COMMISSION_TYPE)->width(3);
                // 修改分佣类型筛选为下拉选择
                $filter->equal('is_div', '是否已分账')->select([0 => '否', 1 => '是'])->width(3);

                // 添加商家筛选
                $filter->where('um_id2', function ($query) {
                    $query->where('sh_type', 3) // 只筛选sh_type=3的记录
                        ->whereHas('order', function ($q) {
                            $q->where('um_id', $this->input);
                        });
                }, '商家')->select(Merchant::pluck('name', 'id'))->width(3);

                // 添加员工筛选
                $filter->where('um_id3', function ($query) {
                    $query->where('sh_type', 5) // 只筛选sh_type=5的记录
                        ->whereHas('order', function ($q) {
                            $q->where('um_id', $this->input);
                        });
                }, '员工')->select(StoreAdminUsers::where('role_id', 3)->pluck('name', 'member_id'))->width(3);

                // 添加时间范围快捷筛选
                $filter->scope('today', '今日')->whereDate('created_at', date('Y-m-d'));
                $filter->scope('month', '本月')->whereMonth('created_at', date('m'));
                $filter->scope('quarter', '本季度')->where(function ($query) {
                    $month = date('m');
                    $year = date('Y');

                    if ($month >= 1 && $month <= 3) {
                        // 第一季度 (1-3月)
                        $start = date('Y-m-d', strtotime('first day of January'));
                        $end = date('Y-m-d', strtotime('last day of March'));
                    } elseif ($month >= 4 && $month <= 6) {
                        // 第二季度 (4-6月)
                        $start = date('Y-m-d', strtotime('first day of April'));
                        $end = date('Y-m-d', strtotime('last day of June'));
                    } elseif ($month >= 7 && $month <= 9) {
                        // 第三季度 (7-9月)
                        $start = date('Y-m-d', strtotime('first day of July'));
                        $end = date('Y-m-d', strtotime('last day of September'));
                    } else {
                        // 第四季度 (10-12月)
                        $start = date('Y-m-d', strtotime('first day of October'));
                        $end = date('Y-m-d', strtotime('last day of December'));
                    }

                    $query->whereBetween('created_at', [$start, $end]);
                });
                $filter->scope('year', '本年')->whereYear('created_at', date('Y'));

                $filter->between('created_at', '创建时间')->datetime()->width(4);
            });





            //先注释，目前没有手动分账金额给平台的功能
            // $grid->actions(function (Grid\Displayers\Actions $actions) {
            //     //分账给平台
            //     if ($actions->row->is_div == 0 && in_array($actions->row->sh_type, [1, 2])) {
            //         $actions->append(new TransferToPlatForm('分账给平台', $actions->row->id));
            //     }
            // });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new OrderDivideRecord(), function (Show $show) {
            $show->field('id');
            $show->field('order_id');
            $show->field('user_id');
            $show->field('og_id');
            $show->field('order_price');
            $show->field('divide_price');
            $show->field('proportion');
            $show->field('sh_type');
            $show->field('is_div');
            $show->field('remark');
            $show->field('um_id');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new OrderDivideRecord(), function (Form $form) {
            $form->display('id');
            $form->text('order_id');
            $form->text('user_id');
            $form->text('og_id');
            $form->text('order_price');
            $form->text('divide_price');
            $form->text('proportion');
            $form->text('sh_type');
            $form->text('is_div');
            $form->text('remark');
            $form->text('um_id');

            $form->display('created_at');
            $form->display('updated_at');
        });
    }
}
