<?php

namespace App\Admin\Controllers;

use App\Models\Income;
use App\Models\User;
use App\Models\Merchant;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use App\Admin\Forms\CheckIncome;
use Dcat\Admin\Http\Controllers\AdminController;

class IncomeController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new Income(), function (Grid $grid) {
            $grid->model()->orderBy('created_at', 'DESC');
            $grid->column('id')->sortable();
            //$grid->column('merchant.name', '商户名称');
            $grid->column('user_type', '提现类型')->using(Income::USER_TYPE, '');
            $grid->column('um_id', '提现人员')->display(function ($vel) {
                if ($this->user_type == 1) {
                    return User::find($vel)->name ?? '';
                }
                return Merchant::find($vel)->name ?? '';
            });
            $grid->column('phone', '手机号')->display(function ($val) {
                return $val ? $val : '';
            });
            $grid->column('amount');
            //$grid->column('status');
            $grid->column('status')
                ->using(Income::STATUS)->dot([
                    0 => 'primary',
                    1 => 'success',
                    2 => 'danger'
                ])
                ->if(function ($column) {
                    return $column->getValue() == 0;
                })->display('点击审批')->modal(function (Grid\Displayers\Modal $modal) {
                    // 标题
                    $modal->title('提现审核');
                    // 自定义图标
                    $modal->icon('feather icon-edit');
                    // 传递当前行字段值
                    return CheckIncome::make()->payload(['id' => $this->id]);
                });
            $grid->column('created_at', '提现时间');
            //$grid->column('updated_at')->sortable();

            $grid->disableCreateButton();
            $grid->disableActions();
            $grid->disableRowSelector();
            $grid->selector(function (Grid\Tools\Selector $selector) {
                $selector->selectOne('status', '状态', Income::STATUS);
            });
            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('phone', '手机号')->width(4);
                $filter->equal('status', '提现类型')->select(Income::USER_TYPE)->width(3);
                $filter->between('created_at', '提现时间')->datetime()->width(4);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new Income(), function (Show $show) {
            $show->field('id');
            $show->field('user_id');
            $show->field('amount');
            $show->field('status');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new Income(), function (Form $form) {
            $form->display('id');
            $form->text('user_id');
            $form->text('amount');
            $form->text('status');

            $form->display('created_at');
            $form->display('updated_at');
        });
    }
}
